/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.culturaldelights.worldgen;

import com.baisylia.culturaldelights.worldgen.ModFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.holdersets.OrHolderSet;

public class ModBiomeModifiers {
    public static final ResourceKey<BiomeModifier> AVOCADO_TREES = ModBiomeModifiers.createKey("trees_avocado");
    public static final ResourceKey<BiomeModifier> WILD_CUCUMBERS = ModBiomeModifiers.createKey("wild_cucumbers");
    public static final ResourceKey<BiomeModifier> WILD_EGGPLANTS = ModBiomeModifiers.createKey("wild_eggplants");
    public static final ResourceKey<BiomeModifier> WILD_CORN = ModBiomeModifiers.createKey("wild_corn");

    public static void init(BootstapContext<BiomeModifier> context) {
        HolderSet.Direct isBambooJungle = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(Biomes.f_48197_)});
        HolderSet.Direct isSparseJungle = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(Biomes.f_186769_)});
        HolderSet.Direct isJungle = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(Biomes.f_48222_)});
        HolderSet.Direct isPlains = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(Biomes.f_48202_)});
        HolderSet.Direct isSwamp = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(Biomes.f_48207_)});
        HolderSet.Direct isMangroveSwamp = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(Biomes.f_220595_)});
        OrHolderSet avocadoTreeBiomes = new OrHolderSet(List.of(isBambooJungle, isSparseJungle, isJungle));
        OrHolderSet wildCornBiomes = new OrHolderSet(List.of(isPlains));
        OrHolderSet wildCucumbersBiomes = new OrHolderSet(List.of(isSwamp, isMangroveSwamp));
        HolderSet.Direct avocadoTrees = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(ModFeatures.Placed.TREES_AVOCADO_PLACED)});
        HolderSet.Direct wildCorn = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(ModFeatures.Placed.WILD_CORN)});
        HolderSet.Direct wildEggplant = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(ModFeatures.Placed.WILD_EGGPLANTS)});
        HolderSet.Direct wildCucumbers = HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(ModFeatures.Placed.WILD_CUCUMBERS)});
        context.m_255272_(AVOCADO_TREES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)avocadoTreeBiomes, (HolderSet)avocadoTrees, GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(WILD_CORN, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)wildCornBiomes, (HolderSet)wildCorn, GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(WILD_CUCUMBERS, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)wildCucumbersBiomes, (HolderSet)wildCucumbers, GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(WILD_EGGPLANTS, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)avocadoTreeBiomes, (HolderSet)wildEggplant, GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("culturaldelights", name));
    }
}

