/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.devtools.screen;

import dev.latvian.mods.kubejs.client.NotificationToast;
import dev.latvian.mods.kubejs.util.NotificationBuilder;
import dev.latvian.mods.rhino.mod.util.color.SimpleColor;
import java.time.Duration;
import java.util.ArrayList;
import net.lmor.devtools.block.ModBlocks;
import net.lmor.devtools.screen.DesignerWorkbench5x5Menu;
import net.lmor.devtools.util.Recipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DesignerWorkbench5x5Screen
extends AbstractContainerScreen<DesignerWorkbench5x5Menu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("devtools", "textures/gui/designer_workbench_5x5.png");
    private static final Component SHAPED_RECIPE = Component.m_237115_((String)"gui.devtools.shaped_button");
    private static final Component SHAPELESS_RECIPE = Component.m_237115_((String)"gui.devtools.shapeless_button");
    private Button shapedButton;
    private Button shapelessButton;
    private int x;
    private int y;

    public DesignerWorkbench5x5Screen(DesignerWorkbench5x5Menu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    protected void m_7856_() {
        this.f_97727_ = 238;
        this.f_97726_ = 176;
        this.f_97731_ = this.f_97727_ - 94;
        super.m_7856_();
        this.x = (this.f_96543_ - this.f_97726_) / 2;
        this.y = (this.f_96544_ - this.f_97727_) / 2;
        this.shapedButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)SHAPED_RECIPE, this::handleShapedButton).m_252987_(this.x + 10, this.y + 119, 65, 20).m_253136_());
        this.shapelessButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)SHAPELESS_RECIPE, this::handleShapelessButton).m_252987_(this.x + 86, this.y + 119, 80, 20).m_253136_());
    }

    private void handleShapedButton(Button button) {
        ItemStack output = ((DesignerWorkbench5x5Menu)this.m_6262_()).blockEntity.getRenderStack();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < 25; ++i) {
            inputs.add(((DesignerWorkbench5x5Menu)this.m_6262_()).blockEntity.getItemHandler().getStackInSlot(i));
        }
        if (this.checkIsAirInputsSlot(inputs)) {
            this.notifyPlayer("gui.devtools.error_input_copy_recipe");
            return;
        }
        if (output.m_41619_()) {
            this.notifyPlayer("gui.devtools.error_output_copy_recipe");
            return;
        }
        Recipe.genShapedRecipeNotCraftingTable(output, inputs, 5, "extendedcrafting:shaped_table", new int[0]);
        this.notifyPlayer("gui.devtools.success_copy_recipe");
    }

    private void handleShapelessButton(Button button) {
        ItemStack output = ((DesignerWorkbench5x5Menu)this.m_6262_()).blockEntity.getRenderStack();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < 25; ++i) {
            inputs.add(((DesignerWorkbench5x5Menu)this.m_6262_()).blockEntity.getItemHandler().getStackInSlot(i));
        }
        if (this.checkIsAirInputsSlot(inputs)) {
            this.notifyPlayer("gui.devtools.error_input_copy_recipe");
            return;
        }
        if (output.m_41619_()) {
            this.notifyPlayer("gui.devtools.error_output_copy_recipe");
            return;
        }
        Recipe.genShapelessRecipeNotCraftingTable(output, inputs, "extendedcrafting:shapeless_table", new int[0]);
        this.notifyPlayer("gui.devtools.success_copy_recipe");
    }

    private void notifyPlayer(String text) {
        Minecraft mc = Minecraft.m_91087_();
        NotificationBuilder builder = new NotificationBuilder();
        builder.text = Component.m_237115_((String)text).m_130940_(ChatFormatting.RED);
        builder.backgroundColor = new SimpleColor(0);
        builder.borderColor = new SimpleColor(334115);
        builder.outlineColor = new SimpleColor(334115);
        builder.duration = Duration.ofSeconds(2L, 0L);
        builder.setItemIcon(((Block)ModBlocks.DESIGNER_WORKBENCH_5x5.get()).m_5456_().m_7968_());
        mc.m_91300_().m_94922_((Toast)new NotificationToast(mc, builder));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280218_(TEXTURE, this.x, this.y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private boolean checkIsAirInputsSlot(ArrayList<ItemStack> inputs) {
        int size = 0;
        for (ItemStack input : inputs) {
            if (!input.m_41619_()) continue;
            ++size;
        }
        return size == inputs.size();
    }
}

