/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.devtools.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.latvian.mods.kubejs.client.NotificationToast;
import dev.latvian.mods.kubejs.util.NotificationBuilder;
import dev.latvian.mods.rhino.mod.util.color.SimpleColor;
import java.time.Duration;
import java.util.Objects;
import net.lmor.devtools.block.ModBlocks;
import net.lmor.devtools.screen.DesignerWorkbenchCompressorMenu;
import net.lmor.devtools.util.Converted;
import net.lmor.devtools.util.Recipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DesignerWorkbenchCompressorScreen
extends AbstractContainerScreen<DesignerWorkbenchCompressorMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("devtools", "textures/gui/designer_workbench_compressor.png");
    private static final ResourceLocation TEXTURE_SINGULARITY = new ResourceLocation("devtools", "textures/item/singularity_map.png");
    private static final Component RECIPE = Component.m_237115_((String)"gui.devtools.singularity");
    private Button singularityButton;
    private EditBox countItem;
    private EditBox colorBox1;
    private EditBox colorBox2;
    private Checkbox addRecipeUltimateSingularity;

    public DesignerWorkbenchCompressorScreen(DesignerWorkbenchCompressorMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    protected void m_7856_() {
        this.f_97727_ = 194;
        this.f_97731_ = this.f_97727_ - 94;
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        String color1 = Converted.convertDECtoHEX(((DesignerWorkbenchCompressorMenu)this.m_6262_()).blockEntity.getData(0));
        String color2 = Converted.convertDECtoHEX(((DesignerWorkbenchCompressorMenu)this.m_6262_()).blockEntity.getData(1));
        this.singularityButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)RECIPE, this::handleSingularitiesButton).m_252987_(x + 100, y + 88, 65, 20).m_253136_());
        this.countItem = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x + 10, y + 51, 48, 10, (Component)Component.m_237115_((String)"gui.devtools.count_item")));
        this.countItem.m_94144_(Integer.toString(((DesignerWorkbenchCompressorMenu)this.m_6262_()).blockEntity.getData(2)));
        this.countItem.m_94153_(this::isNumber);
        this.colorBox1 = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x + 60, y + 22, 60, 10, (Component)Component.m_237113_((String)"")));
        this.colorBox1.m_94153_(this::isHexColor);
        this.colorBox1.m_94144_(color1);
        this.colorBox2 = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x + 60, y + 37, 60, 10, (Component)Component.m_237113_((String)"")));
        this.colorBox2.m_94153_(this::isHexColor);
        this.colorBox2.m_94144_(color2);
        this.addRecipeUltimateSingularity = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(x + 10, y + 65, 20, 20, (Component)Component.m_237119_(), ((DesignerWorkbenchCompressorMenu)this.m_6262_()).blockEntity.getData(3) == 1));
    }

    private void handleSingularitiesButton(Button button) {
        ItemStack input = ((DesignerWorkbenchCompressorMenu)this.m_6262_()).blockEntity.getItemSlot(0);
        if (this.VerificationBeforeSendingData(input)) {
            int count = Integer.parseInt(this.checkValue());
            boolean addUltimateRecipe = this.addRecipeUltimateSingularity.m_93840_();
            String color1 = this.colorBox1.m_94155_();
            String color2 = this.colorBox2.m_94155_();
            Recipe.addSingularity(input, count, addUltimateRecipe, color1, color2);
            this.notifyPlayer("gui.devtools.success_copy_recipe");
        }
    }

    private void notifyPlayer(String text) {
        Minecraft mc = Minecraft.m_91087_();
        NotificationBuilder builder = new NotificationBuilder();
        builder.text = Component.m_237115_((String)text).m_130940_(ChatFormatting.RED);
        builder.backgroundColor = new SimpleColor(0);
        builder.borderColor = new SimpleColor(334115);
        builder.outlineColor = new SimpleColor(334115);
        builder.duration = Duration.ofSeconds(2L, 0L);
        builder.setItemIcon(((Block)ModBlocks.DESIGNER_WORKBENCH_COMPRESSOR.get()).m_5456_().m_7968_());
        mc.m_91300_().m_94922_((Toast)new NotificationToast(mc, builder));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int color1 = Converted.convertHEXtoDEC(this.colorBox1.m_94155_());
        guiGraphics.m_280246_((float)(color1 >> 16 & 0xFF) / 255.0f, (float)(color1 >> 8 & 0xFF) / 255.0f, (float)(color1 & 0xFF) / 255.0f, 1.0f);
        guiGraphics.m_280218_(TEXTURE_SINGULARITY, this.f_97735_ + 137, this.f_97736_ + 27, 0, 0, 16, 16);
        int color2 = Converted.convertHEXtoDEC(this.colorBox2.m_94155_());
        guiGraphics.m_280246_((float)(color2 >> 16 & 0xFF) / 255.0f, (float)(color2 >> 8 & 0xFF) / 255.0f, (float)(color2 & 0xFF) / 255.0f, 1.0f);
        guiGraphics.m_280218_(TEXTURE_SINGULARITY, this.f_97735_ + 137, this.f_97736_ + 27, 16, 0, 16, 16);
        this.drawText(guiGraphics, 0);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private boolean isNumber(String text) {
        try {
            if (Objects.equals(text, "")) {
                return true;
            }
            return Integer.parseInt(text) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean VerificationBeforeSendingData(ItemStack input) {
        if (input.m_41619_()) {
            this.notifyPlayer("gui.devtools.error_input_copy_recipe");
            return false;
        }
        return true;
    }

    private void drawText(GuiGraphics guiGraphics, int color) {
        MutableComponent checkBoxText = Component.m_237115_((String)"gui.devtools.custom_option");
        float scale = this.calculateOptimalScale((Component)checkBoxText, 135);
        if (scale <= 0.0f) {
            scale = 1.0f;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        guiGraphics.m_280488_(this.f_96547_, checkBoxText.getString(), (int)((float)(this.f_97735_ + 35) / scale), (int)((float)(this.f_97736_ + 72) / scale), color);
        poseStack.m_85849_();
    }

    private float calculateOptimalScale(Component text, int maxWidth) {
        int textWidth = this.f_96547_.m_92852_((FormattedText)text);
        if (textWidth <= maxWidth) {
            return 1.0f;
        }
        return (float)maxWidth / (float)textWidth;
    }

    private boolean isHexColor(String text) {
        return text.matches("^#([A-Fa-f0-9]{0,6})$");
    }

    public void m_7379_() {
        String count = this.checkValue();
        ((DesignerWorkbenchCompressorMenu)this.m_6262_()).blockEntity.setData(0, Converted.convertHEXtoDEC(this.colorBox1.m_94155_()));
        ((DesignerWorkbenchCompressorMenu)this.m_6262_()).blockEntity.setData(1, Converted.convertHEXtoDEC(this.colorBox2.m_94155_()));
        ((DesignerWorkbenchCompressorMenu)this.m_6262_()).blockEntity.setData(2, Integer.parseInt(count));
        ((DesignerWorkbenchCompressorMenu)this.m_6262_()).blockEntity.setData(3, this.addRecipeUltimateSingularity.m_93840_() ? 1 : 0);
        super.m_7379_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        KeyMapping inventoryKey = Minecraft.m_91087_().f_91066_.f_92092_;
        if (this.colorBox1.m_93696_() || this.colorBox2.m_93696_()) {
            if (keyCode == inventoryKey.getKey().m_84873_()) {
                return true;
            }
            return this.colorBox1.m_7933_(keyCode, scanCode, modifiers) || this.colorBox2.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.colorBox1.m_93696_() || this.colorBox2.m_93696_()) {
            return this.colorBox1.m_5534_(codePoint, modifiers) || this.colorBox2.m_5534_(codePoint, modifiers);
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private String checkValue() {
        return this.countItem.m_94155_().equals("") ? "1" : this.countItem.m_94155_();
    }
}

