/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.devtools.screen;

import dev.latvian.mods.kubejs.client.NotificationToast;
import dev.latvian.mods.kubejs.util.NotificationBuilder;
import dev.latvian.mods.rhino.mod.util.color.SimpleColor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import net.lmor.devtools.block.ModBlocks;
import net.lmor.devtools.screen.DesignerWorkbenchFluxCraftingMenu;
import net.lmor.devtools.util.Recipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DesignerWorkbenchFluxCraftingScreen
extends AbstractContainerScreen<DesignerWorkbenchFluxCraftingMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("devtools", "textures/gui/designer_workbench_flux_crafting.png");
    private static final Component SHAPED_RECIPE = Component.m_237115_((String)"gui.devtools.shaped_button");
    private static final Component SHAPELESS_RECIPE = Component.m_237115_((String)"gui.devtools.shapeless_button");
    private Button shapedButton;
    private Button shapelessButton;
    private EditBox fluxCountBox;
    private EditBox fluxPerTickBox;

    public DesignerWorkbenchFluxCraftingScreen(DesignerWorkbenchFluxCraftingMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    protected void m_7856_() {
        this.f_97727_ = 202;
        this.f_97731_ = this.f_97727_ - 94;
        super.m_7856_();
        int fluxCount = ((DesignerWorkbenchFluxCraftingMenu)this.m_6262_()).blockEntity.getData(0);
        int fluxPerTick = ((DesignerWorkbenchFluxCraftingMenu)this.m_6262_()).blockEntity.getData(1);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.shapedButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)SHAPED_RECIPE, this::handleShapedButton).m_252987_(x + 10, y + 83, 65, 20).m_253136_());
        this.shapelessButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)SHAPELESS_RECIPE, this::handleShapelessButton).m_252987_(x + 86, y + 83, 80, 20).m_253136_());
        this.fluxCountBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x + 110, y + 27, 60, 10, (Component)Component.m_237113_((String)"")));
        this.fluxCountBox.m_94153_(this::isNumber);
        this.fluxCountBox.m_94144_(Integer.toString(fluxCount));
        this.fluxPerTickBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x + 110, y + 57, 60, 10, (Component)Component.m_237113_((String)"")));
        this.fluxPerTickBox.m_94153_(this::isNumber);
        this.fluxPerTickBox.m_94144_(Integer.toString(fluxPerTick));
    }

    private void handleShapedButton(Button button) {
        ItemStack output = ((DesignerWorkbenchFluxCraftingMenu)this.m_6262_()).blockEntity.getRenderStack();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            inputs.add(((DesignerWorkbenchFluxCraftingMenu)this.m_6262_()).blockEntity.getItemHandler().getStackInSlot(i));
        }
        if (this.VerificationBeforeSendingData(inputs)) {
            int fluxCount = Integer.parseInt(this.checkValue(this.fluxCountBox.m_94155_()));
            int fluxPerTick = Integer.parseInt(this.checkValue(this.fluxPerTickBox.m_94155_()));
            Recipe.genShapedRecipeNotCraftingTable(output, inputs, 3, "extendedcrafting:shaped_flux_crafter", fluxCount, fluxPerTick);
            this.notifyPlayer("gui.devtools.success_copy_recipe");
        }
    }

    private void handleShapelessButton(Button button) {
        ItemStack output = ((DesignerWorkbenchFluxCraftingMenu)this.m_6262_()).blockEntity.getRenderStack();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            inputs.add(((DesignerWorkbenchFluxCraftingMenu)this.m_6262_()).blockEntity.getItemHandler().getStackInSlot(i));
        }
        if (this.VerificationBeforeSendingData(inputs)) {
            int fluxCount = Integer.parseInt(this.checkValue(this.fluxCountBox.m_94155_()));
            int fluxPerTick = Integer.parseInt(this.checkValue(this.fluxPerTickBox.m_94155_()));
            Recipe.genShapelessRecipeNotCraftingTable(output, inputs, "extendedcrafting:shapeless_flux_crafter", fluxCount, fluxPerTick);
            this.notifyPlayer("gui.devtools.success_copy_recipe");
        }
    }

    private void notifyPlayer(String text) {
        Minecraft mc = Minecraft.m_91087_();
        NotificationBuilder builder = new NotificationBuilder();
        builder.text = Component.m_237115_((String)text).m_130940_(ChatFormatting.RED);
        builder.backgroundColor = new SimpleColor(0);
        builder.borderColor = new SimpleColor(334115);
        builder.outlineColor = new SimpleColor(334115);
        builder.duration = Duration.ofSeconds(2L, 0L);
        builder.setItemIcon(((Block)ModBlocks.DESIGNER_WORKBENCH_FLUX_CRAFTING.get()).m_5456_().m_7968_());
        mc.m_91300_().m_94922_((Toast)new NotificationToast(mc, builder));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        guiGraphics.m_280218_(TEXTURE, (this.f_96543_ - this.f_97726_) / 2, (this.f_96544_ - this.f_97727_) / 2, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.drawText(guiGraphics, 0xFFFFFF);
    }

    private void drawText(GuiGraphics guiGraphics, int color) {
        MutableComponent fluxCountText = Component.m_237115_((String)"gui.devtools.flux_count");
        float scale = this.calculateOptimalScale((Component)fluxCountText, 60);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280488_(this.f_96547_, fluxCountText.getString(), (int)(((float)(this.f_97735_ + 140) - (float)this.f_96547_.m_92852_((FormattedText)fluxCountText) * scale / 2.0f) / scale), (int)((float)(this.f_97736_ + 17) / scale), color);
        guiGraphics.m_280168_().m_85849_();
        MutableComponent fluxPerTickText = Component.m_237115_((String)"gui.devtools.flux_per_tick");
        scale = this.calculateOptimalScale((Component)fluxPerTickText, 60);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280488_(this.f_96547_, fluxPerTickText.getString(), (int)(((float)(this.f_97735_ + 140) - (float)this.f_96547_.m_92852_((FormattedText)fluxPerTickText) * scale / 2.0f) / scale), (int)((float)(this.f_97736_ + 47) / scale), color);
        guiGraphics.m_280168_().m_85849_();
    }

    private float calculateOptimalScale(Component text, int maxWidth) {
        int textWidth = this.f_96547_.m_92852_((FormattedText)text);
        if (textWidth <= maxWidth) {
            return 1.0f;
        }
        return (float)maxWidth / (float)textWidth;
    }

    private boolean checkIsAirInputsSlot(ArrayList<ItemStack> inputs) {
        int size = 0;
        for (ItemStack input : inputs) {
            if (!input.m_41619_()) continue;
            ++size;
        }
        return size == inputs.size();
    }

    private boolean VerificationBeforeSendingData(ArrayList<ItemStack> inputs) {
        if (this.checkIsAirInputsSlot(inputs)) {
            this.notifyPlayer("gui.devtools.error_input_copy_recipe");
            return false;
        }
        return true;
    }

    private boolean isNumber(String text) {
        try {
            if (Objects.equals(text, "")) {
                return true;
            }
            return Integer.parseInt(text) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private String checkValue(String value) {
        return value.equals("") ? "1000" : value;
    }

    public void m_7379_() {
        ((DesignerWorkbenchFluxCraftingMenu)this.m_6262_()).blockEntity.setData(0, Integer.parseInt(this.checkValue(this.fluxCountBox.m_94155_())));
        ((DesignerWorkbenchFluxCraftingMenu)this.m_6262_()).blockEntity.setData(1, Integer.parseInt(this.checkValue(this.fluxPerTickBox.m_94155_())));
        super.m_7379_();
    }
}

