/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.devtools.util;

import dev.latvian.mods.kubejs.item.ItemStackJS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class Recipe {
    public static void genShapedRecipe(ItemStack output, ArrayList<ItemStack> inputs) {
        for (ItemStack input : inputs) {
            System.out.println("  " + Recipe.createItemRepresentation(input));
        }
        StringBuilder shape = new StringBuilder();
        HashMap<String, Character> itemToChar = new HashMap<String, Character>();
        HashMap<Character, String> mapping = new HashMap<Character, String>();
        char currentChar = 'A';
        for (int i = 0; i < 3; ++i) {
            StringBuilder row = new StringBuilder();
            for (int j = 0; j < 3; ++j) {
                int index = i * 3 + j;
                if (index < inputs.size() && !inputs.get(index).m_41619_()) {
                    String item = ItemStackJS.toItemString((Object)inputs.get(index));
                    if (!item.contains("minecraft:air")) {
                        if (!itemToChar.containsKey(item)) {
                            itemToChar.put(item, Character.valueOf(currentChar));
                            mapping.put(Character.valueOf(currentChar), Recipe.createItemRepresentation(inputs.get(index)));
                            currentChar = (char)(currentChar + '\u0001');
                        }
                        row.append(itemToChar.get(item));
                        continue;
                    }
                    row.append(' ');
                    continue;
                }
                row.append(' ');
            }
            shape.append("'").append((CharSequence)row).append("'");
            if (i >= 2) continue;
            shape.append(",\n            ");
        }
        System.out.println("\u0424\u043e\u0440\u043c\u0430 \u0440\u0435\u0446\u0435\u043f\u0442\u0430: " + shape);
        StringBuilder script = new StringBuilder("event.shaped(").append(Recipe.createItemRepresentation(output)).append(",\n        [\n            ").append((CharSequence)shape).append("\n        ],\n        {\n");
        for (Map.Entry entry : mapping.entrySet()) {
            script.append("            ").append(entry.getKey()).append(": ").append((String)entry.getValue()).append(",\n");
        }
        if (!mapping.isEmpty()) {
            script.delete(script.length() - 2, script.length());
        }
        script.append("\n        }\n    )");
        System.out.println("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0446\u0435\u043f\u0442: " + script);
        String result = script.toString();
        Recipe.copyToClipboard(result);
    }

    public static void genShapelessRecipe(ItemStack output, ArrayList<ItemStack> inputs) {
        StringBuilder script = new StringBuilder("event.shapeless(").append(Recipe.createItemRepresentation(output)).append(", [\n");
        for (ItemStack input : inputs) {
            String item = Recipe.createItemRepresentation(input);
            if (item.contains("minecraft:air")) continue;
            script.append("  ").append(item).append(",\n");
        }
        if (script.toString().endsWith(",\n")) {
            script.setLength(script.length() - 2);
        }
        script.append("\n])");
        String result = script.toString();
        Recipe.copyToClipboard(result);
    }

    public static void genShapedRecipeNotCraftingTable(ItemStack output, ArrayList<ItemStack> inputs, int size, String type, int ... flux) {
        StringBuilder shape = new StringBuilder();
        HashMap<String, Character> itemToChar = new HashMap<String, Character>();
        HashMap<Character, String> mapping = new HashMap<Character, String>();
        int flux_count = -999;
        int flux_per_tick = -999;
        if (flux.length != 0) {
            flux_count = flux[0];
            flux_per_tick = flux[1];
        }
        char currentChar = 'A';
        for (int i = 0; i < size; ++i) {
            StringBuilder row = new StringBuilder();
            for (int j = 0; j < size; ++j) {
                int index = i * size + j;
                if (index < inputs.size() && inputs.get(index) != null) {
                    String item = ItemStackJS.toItemString((Object)inputs.get(index));
                    if (!item.contains("minecraft:air")) {
                        if (!itemToChar.containsKey(item)) {
                            itemToChar.put(item, Character.valueOf(currentChar));
                            mapping.put(Character.valueOf(currentChar), Recipe.createItemRepresentation(inputs.get(index)));
                            currentChar = (char)(currentChar + '\u0001');
                        }
                        row.append(itemToChar.get(item));
                        continue;
                    }
                    row.append(' ');
                    continue;
                }
                row.append(' ');
            }
            if (i < size - 1) {
                row.append("',\n    '");
            }
            shape.append((CharSequence)row);
        }
        StringBuilder script = new StringBuilder("event.custom(\n{").append("\n'type': '" + type + "',\n").append("'pattern': [\n'").append((CharSequence)shape).append("'\n],\n'key': {\n");
        for (Map.Entry entry : mapping.entrySet()) {
            script.append("  '").append(entry.getKey()).append("': ").append((String)entry.getValue()).append(",\n");
        }
        if (!mapping.isEmpty()) {
            script.delete(script.length() - 2, script.length());
        }
        if (output.m_41782_()) {
            script.append("\n},\n'result': ").append(Recipe.createItemRepresentation(output));
        } else {
            script.append("\n},\n'result': {\n").append("'item': ").append(Recipe.createItemRepresentation(output)).append("\n}");
        }
        if (flux_count != -999) {
            script.append(",\n'powerRequired': ").append(flux_count).append(",\n");
            script.append("'powerRate': ").append(flux_per_tick);
        }
        script.append("\n}\n)");
        String result = script.toString();
        Recipe.copyToClipboard(result);
    }

    public static void genShapelessRecipeNotCraftingTable(ItemStack output, ArrayList<ItemStack> inputs, String type, int ... flux) {
        StringBuilder script = new StringBuilder("event.custom(\n{\n'type': '" + type + "',\n'ingredients': [\n");
        int flux_count = -999;
        int flux_per_tick = -999;
        if (flux.length != 0) {
            flux_count = flux[0];
            flux_per_tick = flux[1];
        }
        for (ItemStack input : inputs) {
            String item = Recipe.createItemRepresentation(input);
            if (item.contains("minecraft:air")) continue;
            if (input.m_41782_()) {
                script.append(item).append(",\n");
                continue;
            }
            script.append("{ 'item': ").append(item).append(" },\n");
        }
        if (script.toString().endsWith(",\n")) {
            script.setLength(script.length() - 2);
        }
        if (output.m_41782_()) {
            script.append("\n],\n'result': ").append(Recipe.createItemRepresentation(output));
        } else {
            script.append("\n],\n'result': {\n 'item': ").append(Recipe.createItemRepresentation(output)).append("\n}");
        }
        if (flux_count != -999) {
            script.append(",\n'powerRequired': ").append(flux_count).append(",\n");
            script.append("'powerRate': ").append(flux_per_tick);
        }
        script.append("\n}\n)");
        String result = script.toString();
        Recipe.copyToClipboard(result);
    }

    public static void addSingularity(ItemStack output, int countItem, boolean addUltimateRecipe, String color1, String color2) {
        StringBuilder script = new StringBuilder(Component.m_237115_((String)"instruction.devtools.compressor").getString()).append("\n{\n\t'name': 'singularity.extendedcrafting.").append(output.m_41720_()).append("',\n").append("\t'colors': [\n\t\t'").append(color1.split("#")[1]).append("',\n\t\t'").append(color2.split("#")[1]).append("',\n\t],\n").append("\t'ingredient': {\n\t\t'item': ").append(ItemStackJS.toItemString((Object)output.m_41720_())).append("\n\t},\n").append("\t'inUltimateSingularity': ").append(addUltimateRecipe).append(",\n").append("\t'materialCount': ").append(countItem).append("\n}");
        String result = script.toString();
        Recipe.copyToClipboard(result);
    }

    private static void copyToClipboard(String text) {
        Minecraft.m_91087_().f_91068_.m_90911_(text);
    }

    private static String createItemRepresentation(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            CompoundTag nbt = itemStack.m_41783_();
            String itemKey = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString();
            return "{\n'type': 'forge:nbt',\n'item': '" + itemKey + "',\n'count': " + itemStack.m_41613_() + ",\n'nbt': '" + nbt + "'\n}";
        }
        return ItemStackJS.toItemString((Object)itemStack);
    }
}

