/*
 * Decompiled with CFR 0.152.
 */
package com.ofek2608.emc_interface;

import com.ofek2608.emc_interface.EMCInterfaceConfig;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.api.proxy.ITransmutationProxy;
import moze_intel.projecte.impl.capability.KnowledgeImpl;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

public class EMCContent {
    private static final Map<UUID, EMCContent> MEMORIZED = new HashMap<UUID, EMCContent>();
    private final ServerPlayer player;
    private final IEMCProxy emcProxy;
    private final IKnowledgeProvider knowledgeProvider;
    public final int count;
    public final ItemInfo[] infos;
    public final ItemStack[] stacks;

    public static EMCContent get(UUID owner) {
        return MEMORIZED.computeIfAbsent(owner, EMCContent::new);
    }

    private EMCContent(UUID owner) {
        boolean valid;
        IKnowledgeProvider knowledgeProvider;
        try {
            knowledgeProvider = ITransmutationProxy.INSTANCE.getKnowledgeProviderFor(owner);
            valid = true;
        }
        catch (Exception e) {
            knowledgeProvider = KnowledgeImpl.getDefault();
            valid = false;
        }
        this.player = valid ? ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(owner) : null;
        this.emcProxy = IEMCProxy.INSTANCE;
        this.knowledgeProvider = knowledgeProvider;
        BigInteger emcCount = knowledgeProvider.getEmc();
        int count = 0;
        ArrayList<ItemInfo> infos = new ArrayList<ItemInfo>();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemInfo info : knowledgeProvider.getKnowledge()) {
            long value = this.emcProxy.getValue(info);
            int maxExtract = EMCContent.getMaxExtract(emcCount, value);
            if (maxExtract <= 0) continue;
            ItemStack stack = info.createStack();
            stack.m_41764_(Math.min(maxExtract, (Integer)EMCInterfaceConfig.MAX_ITEMS.get()));
            ++count;
            infos.add(info);
            stacks.add(stack);
        }
        this.count = count;
        this.infos = (ItemInfo[])infos.toArray(ItemInfo[]::new);
        this.stacks = (ItemStack[])stacks.toArray(ItemStack[]::new);
    }

    public boolean insert(ItemStack stack, boolean simulate) {
        if (this.player == null) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        long sellValue = this.emcProxy.getSellValue(stack);
        if (sellValue <= 0L) {
            return false;
        }
        if (simulate) {
            return true;
        }
        BigInteger baseEMC = this.knowledgeProvider.getEmc();
        BigInteger addEMC = BigInteger.valueOf(sellValue).multiply(BigInteger.valueOf(stack.m_41613_()));
        BigInteger newEMC = baseEMC.add(addEMC);
        this.knowledgeProvider.setEmc(newEMC);
        this.sync(this.knowledgeProvider.addKnowledge(stack));
        return true;
    }

    public int extract(ItemInfo info, int max, boolean simulate) {
        if (this.player == null) {
            return 0;
        }
        long value = this.emcProxy.getValue(info);
        BigInteger baseEMC = this.knowledgeProvider.getEmc();
        int maxExtract = Math.min(EMCContent.getMaxExtract(baseEMC, value), max);
        if (maxExtract <= 0) {
            return 0;
        }
        if (simulate) {
            return maxExtract;
        }
        BigInteger removeEMC = BigInteger.valueOf(value).multiply(BigInteger.valueOf(maxExtract));
        BigInteger newEMC = baseEMC.subtract(removeEMC);
        this.knowledgeProvider.setEmc(newEMC);
        this.sync(false);
        return maxExtract;
    }

    private void sync(boolean syncKnowledge) {
        if (this.player == null) {
            return;
        }
        if (syncKnowledge) {
            this.knowledgeProvider.sync(this.player);
        } else {
            this.knowledgeProvider.syncEmc(this.player);
        }
    }

    private static int getMaxExtract(BigInteger emcCount, long cost) {
        if (emcCount.signum() <= 0 || cost <= 0L) {
            return 0;
        }
        try {
            return emcCount.divide(BigInteger.valueOf(cost)).intValueExact();
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    @Mod.EventBusSubscriber(modid="emc_interface", bus=Mod.EventBusSubscriber.Bus.FORGE)
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void event(TickEvent.ServerTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            MEMORIZED.clear();
        }
    }
}

