/*
 * Decompiled with CFR 0.152.
 */
package com.ofek2608.emc_interface;

import com.ofek2608.emc_interface.EMCContent;
import com.ofek2608.emc_interface.EMCInterfaceBlockEntity;
import moze_intel.projecte.api.ItemInfo;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EMCInterfaceItemHandler
implements IItemHandler {
    private final EMCInterfaceBlockEntity blockEntity;

    public EMCInterfaceItemHandler(EMCInterfaceBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    private EMCContent getContent() {
        return EMCContent.get(this.blockEntity.getOwner());
    }

    public int getSlots() {
        EMCContent content = this.getContent();
        return content.count + 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (--slot < 0) {
            return ItemStack.f_41583_;
        }
        EMCContent content = this.getContent();
        return slot < content.count ? content.stacks[slot].m_41777_() : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (slot != 0) {
            return stack;
        }
        EMCContent content = this.getContent();
        return content.insert(stack, simulate) ? ItemStack.f_41583_ : stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (--slot < 0) {
            return ItemStack.f_41583_;
        }
        EMCContent content = this.getContent();
        if (slot >= content.count) {
            return ItemStack.f_41583_;
        }
        ItemInfo info = content.infos[slot];
        int extracted = content.extract(info, amount, simulate);
        if (extracted <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = info.createStack();
        stack.m_41764_(extracted);
        return stack;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return slot == 0;
    }
}

