/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math;

import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFException;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathBinaryExpressionComponent;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathConstant;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathOperator;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.models.animation.math.MathVariable;
import traben.entity_model_features.utils.EMFUtils;

public class MathExpressionParser {
    public static final MathComponent NULL_EXPRESSION = () -> {
        EMFUtils.logError("ERROR: NULL_EXPRESSION was called, this should not happen.");
        return Float.NaN;
    };
    private static final List<MathOperator> BOOLEAN_COMPARATOR_ACTIONS = List.of(MathOperator.EQUALS, MathOperator.SMALLER_THAN_OR_EQUALS, MathOperator.SMALLER_THAN, MathOperator.LARGER_THAN_OR_EQUALS, MathOperator.LARGER_THAN, MathOperator.NOT_EQUALS);
    private static final List<MathOperator> BOOLEAN_LOGICAL_ACTIONS = List.of(MathOperator.AND, MathOperator.OR);
    private static final List<MathOperator> MULTIPLICATION_ACTIONS = List.of(MathOperator.MULTIPLY, MathOperator.DIVIDE, MathOperator.DIVISION_REMAINDER);
    private static final List<MathOperator> ADDITION_ACTIONS = List.of(MathOperator.ADD, MathOperator.SUBTRACT);
    private final String originalExpression;
    private final boolean wasInvertedBooleanExpression;
    private final boolean isNegative;
    private final EMFAnimation calculationInstance;
    private MathComponent optimizedComponent = null;
    private CalculationList components;
    private boolean nextValueIsNegative = false;
    private String caughtExceptionString = null;

    private MathExpressionParser(String expressionString, boolean isNegative, EMFAnimation calculationInstance, boolean invertBoolean) {
        this.isNegative = isNegative;
        this.calculationInstance = calculationInstance;
        this.wasInvertedBooleanExpression = invertBoolean;
        this.originalExpression = expressionString = expressionString.trim();
        this.components = new CalculationList();
        try {
            RollingReader rollingReader = new RollingReader();
            CharArrayList charList = new CharArrayList(expressionString.toCharArray());
            CharListIterator charIterator = charList.iterator();
            Character firstBooleanChar = null;
            while (charIterator.hasNext()) {
                char currentChar = charIterator.nextChar();
                if (Character.isWhitespace(currentChar)) continue;
                MathOperator asAction = MathOperator.getAction(currentChar);
                if (firstBooleanChar != null) {
                    if (asAction == MathOperator.BOOLEAN_CHAR) {
                        this.readDoubleBooleanAction(calculationInstance, firstBooleanChar, currentChar);
                        if (!charIterator.hasNext()) {
                            throw new EMFMathException("ERROR: boolean operator [" + firstBooleanChar + currentChar + "] at end of expression for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
                        }
                        currentChar = charIterator.nextChar();
                        asAction = MathOperator.getAction(currentChar);
                    } else {
                        this.readLastSingleBooleanAction(calculationInstance, firstBooleanChar, rollingReader);
                    }
                    firstBooleanChar = null;
                }
                if (asAction == MathOperator.BOOLEAN_CHAR) {
                    firstBooleanChar = Character.valueOf(currentChar);
                }
                if (asAction == MathOperator.SUBTRACT && (this.components.isEmpty() && rollingReader.isEmpty() || !this.components.isEmpty() && this.components.getLast() instanceof MathOperator && rollingReader.isEmpty())) {
                    this.nextValueIsNegative = true;
                    continue;
                }
                if (asAction == MathOperator.NONE) {
                    rollingReader.write(currentChar);
                    continue;
                }
                if (asAction == MathOperator.OPEN_BRACKET) {
                    this.readMethodOrBrackets(rollingReader, charIterator);
                    continue;
                }
                this.readVariableOrConstant(rollingReader);
                if (!rollingReader.isEmpty() || asAction == MathOperator.BOOLEAN_CHAR) continue;
                this.components.add(asAction);
            }
            this.readVariableOrConstant(rollingReader);
            if (this.components.isEmpty()) {
                throw new EMFMathException("ERROR: math components found to be empty for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "]");
            }
            CalculationList newComponents = new CalculationList();
            MathComponent lastComponent = null;
            ObjectListIterator objectListIterator = this.components.iterator();
            while (objectListIterator.hasNext()) {
                MathComponent component = (MathComponent)objectListIterator.next();
                if (lastComponent instanceof MathOperator && component instanceof MathOperator) {
                    MathOperator action = (MathOperator)component;
                    if (action != MathOperator.ADD) {
                        newComponents.add(component);
                    }
                } else {
                    newComponents.add(component);
                }
                lastComponent = component;
            }
            if (newComponents.get(0) == MathOperator.ADD) {
                newComponents.remove(0);
            }
            if (newComponents.size() != this.components.size()) {
                this.components = newComponents;
            }
            this.validateAndOptimize();
        }
        catch (EMFMathException e) {
            this.caughtExceptionString = e.toString();
        }
        catch (Exception e) {
            this.caughtExceptionString = "EMF animation ERROR: for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "] cause [" + e + "].";
            e.printStackTrace();
        }
    }

    public static MathComponent getOptimizedExpression(String expressionString, boolean isNegative, EMFAnimation calculationInstance) {
        return MathExpressionParser.getOptimizedExpression(expressionString, isNegative, calculationInstance, false);
    }

    private static MathComponent getOptimizedExpression(String expressionString, boolean isNegative, EMFAnimation calculationInstance, boolean invertBoolean) {
        try {
            MathExpressionParser expression = new MathExpressionParser(expressionString, isNegative, calculationInstance, invertBoolean);
            MathComponent optimized = expression.optimizedComponent;
            if (optimized == null) {
                return NULL_EXPRESSION;
            }
            if (expression.wasInvertedBooleanExpression) {
                return () -> MathValue.invertBoolean(optimized.getResult());
            }
            return optimized;
        }
        catch (Exception e) {
            EMFUtils.logError("EMF animation ERROR: for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "] because [" + e + "].");
            return NULL_EXPRESSION;
        }
    }

    private static String readBracketContents(CharListIterator charIterator) {
        StringBuilder bracketContents = new StringBuilder();
        int nesting = 0;
        while (charIterator.hasNext()) {
            char ch2 = charIterator.nextChar();
            if (ch2 == '(') {
                ++nesting;
            } else if (ch2 == ')') {
                if (nesting == 0) break;
                --nesting;
            }
            bracketContents.append(ch2);
        }
        return bracketContents.toString();
    }

    private void readLastSingleBooleanAction(EMFAnimation calculationInstance, Character firstBooleanChar, RollingReader rollingReader) throws EMFMathException {
        if (firstBooleanChar.charValue() == '!') {
            rollingReader.write('!');
        } else {
            this.components.add(switch (firstBooleanChar.charValue()) {
                case '=' -> MathOperator.EQUALS;
                case '&' -> MathOperator.AND;
                case '|' -> MathOperator.OR;
                case '<' -> MathOperator.SMALLER_THAN;
                case '>' -> MathOperator.LARGER_THAN;
                default -> throw new EMFMathException("ERROR: with boolean processing for operator [" + firstBooleanChar + "] for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
            });
        }
    }

    private void readDoubleBooleanAction(EMFAnimation calculationInstance, Character firstBooleanChar, char currentChar) throws EMFMathException {
        MathOperator doubleAction = switch ("" + firstBooleanChar + currentChar) {
            case "==" -> MathOperator.EQUALS;
            case "!=" -> MathOperator.NOT_EQUALS;
            case "&&" -> MathOperator.AND;
            case "||" -> MathOperator.OR;
            case ">=" -> MathOperator.LARGER_THAN_OR_EQUALS;
            case "<=" -> MathOperator.SMALLER_THAN_OR_EQUALS;
            default -> throw new EMFMathException("ERROR: with boolean processing for operator [" + firstBooleanChar + currentChar + "] for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
        };
        this.components.add(doubleAction);
    }

    private void readMethodOrBrackets(RollingReader rollingReader, CharListIterator charIterator) throws EMFMathException {
        String functionName = rollingReader.read();
        String bracketContents = MathExpressionParser.readBracketContents(charIterator);
        if (functionName.isEmpty() || "!".equals(functionName) || "-".equals(functionName)) {
            this.components.add(MathExpressionParser.getOptimizedExpression(bracketContents, this.getNegativeNext() || "-".equals(functionName), this.calculationInstance, "!".equals(functionName)));
        } else {
            this.components.add(MathMethod.getOptimizedExpression(functionName, bracketContents, this.getNegativeNext(), this.calculationInstance));
        }
    }

    private void readVariableOrConstant(RollingReader rollingReader) throws EMFMathException {
        if (rollingReader.isEmpty()) {
            return;
        }
        String read = rollingReader.read();
        try {
            float number = Float.parseFloat(read);
            if (read.startsWith(".") && ((EMFConfig)EMF.config().getConfig()).enforceOptiFineAnimSyntaxLimits) {
                throw new EMFMathException("ERROR: number [" + read + "] in expression [" + this.originalExpression + "] for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "] is not valid in OptiFine. It must not start with '.' please add a zero");
            }
            this.components.add(new MathConstant(number, this.getNegativeNext()));
        }
        catch (NumberFormatException ignored) {
            if (read.matches("^(\\d|_).*") && ((EMFConfig)EMF.config().getConfig()).enforceOptiFineAnimSyntaxLimits) {
                throw new EMFMathException("ERROR: variable [" + read + "] in expression [" + this.originalExpression + "] for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "] is not valid in OptiFine. It must not start with '.' please add a zero");
            }
            this.components.add(MathVariable.getOptimizedVariable(read, this.getNegativeNext(), this.calculationInstance));
        }
    }

    protected void validateAndOptimize() {
        if (this.caughtExceptionString != null) {
            EMFUtils.logWarn(this.caughtExceptionString);
            new EMFMathException(this.caughtExceptionString).record();
            return;
        }
        if (Float.isNaN(this.validateCalculationAndOptimize())) {
            EMFUtils.logWarn("result was NaN, expression not valid: " + this.originalExpression);
            new EMFMathException("result was NaN, expression not valid: " + this.originalExpression).record();
        }
    }

    private boolean getNegativeNext() {
        boolean neg = this.nextValueIsNegative;
        this.nextValueIsNegative = false;
        return neg;
    }

    private float validateCalculationAndOptimize() {
        if (this.components.size() == 1) {
            MathComponent comp = this.components.getLast();
            if (comp instanceof MathConstant) {
                MathConstant constnt = (MathConstant)comp;
                if (this.isNegative) {
                    comp = new MathConstant(-constnt.getResult());
                }
            } else if (comp instanceof MathValue) {
                MathValue val = (MathValue)comp;
                val.isNegative = this.isNegative != val.isNegative;
            }
            this.optimizedComponent = comp;
            return comp.getResult();
        }
        try {
            CalculationList optimised = this.optimiseTheseActionsIntoBinaryComponents(BOOLEAN_LOGICAL_ACTIONS, this.optimiseTheseActionsIntoBinaryComponents(BOOLEAN_COMPARATOR_ACTIONS, this.optimiseTheseActionsIntoBinaryComponents(ADDITION_ACTIONS, this.optimiseTheseActionsIntoBinaryComponents(MULTIPLICATION_ACTIONS, new CalculationList(this.components)))));
            if (optimised.size() == 1) {
                float result = optimised.getLast().getResult();
                if (Float.isNaN(result)) {
                    EMFUtils.logError(" result was NaN in [" + this.calculationInstance.modelName + "] for expression: " + this.originalExpression + " as " + this.components);
                } else {
                    this.optimizedComponent = optimised.getLast();
                    MathComponent mathComponent = this.optimizedComponent;
                    if (mathComponent instanceof MathValue) {
                        MathValue value = (MathValue)mathComponent;
                        if (this.isNegative) {
                            this.optimizedComponent = value.makeNegative();
                        }
                    }
                }
                return result;
            }
            EMFUtils.logError("ERROR: calculation did not result in 1 component, found: " + optimised + " in [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].");
            EMFUtils.logError("\texpression was [" + this.originalExpression + "].");
        }
        catch (Exception e) {
            String message = "EMF animation ERROR: expression error in [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "] caused by [" + e + "].";
            EMFUtils.logError(message);
            new EMFException(message).record();
        }
        return Float.NaN;
    }

    private CalculationList optimiseTheseActionsIntoBinaryComponents(List<MathOperator> actionsForThisPass, CalculationList componentsOptimized) {
        List<MathOperator> containedActions = actionsForThisPass.stream().filter(arg_0 -> ((CalculationList)componentsOptimized).contains(arg_0)).toList();
        if (containedActions.isEmpty()) {
            return componentsOptimized;
        }
        CalculationList newComponents = new CalculationList();
        ObjectListIterator compIterator = componentsOptimized.iterator();
        while (compIterator.hasNext()) {
            MathOperator action;
            MathComponent component = (MathComponent)compIterator.next();
            if (component instanceof MathOperator && containedActions.contains(action = (MathOperator)component)) {
                MathComponent last = newComponents.getLast();
                MathComponent next = (MathComponent)compIterator.next();
                newComponents.remove(newComponents.size() - 1);
                newComponents.add(MathBinaryExpressionComponent.getOptimizedExpression(last, action, next));
                continue;
            }
            newComponents.add(component);
        }
        return newComponents;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        ObjectListIterator objectListIterator = this.components.iterator();
        while (objectListIterator.hasNext()) {
            MathComponent comp = (MathComponent)objectListIterator.next();
            builder.append(comp.toString()).append(" ");
        }
        builder.append("}");
        return builder.toString();
    }

    private static class CalculationList
    extends ObjectArrayList<MathComponent> {
        public CalculationList(CalculationList components) {
            super((ObjectList)components);
        }

        public CalculationList() {
        }

        public MathComponent getLast() {
            return (MathComponent)super.get(this.size - 1);
        }
    }

    private static class RollingReader {
        private StringBuilder builder = new StringBuilder();

        private RollingReader() {
        }

        void clear() {
            this.builder = new StringBuilder();
        }

        void write(char ch) {
            this.builder.append(ch);
        }

        String read() {
            String result = this.builder.toString();
            this.clear();
            return result;
        }

        public String toString() {
            return this.builder.toString();
        }

        boolean isEmpty() {
            return this.builder.isEmpty();
        }
    }
}

