/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui.entries;

import com.demonwav.mcdev.annotations.Translatable;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import traben.tconfig.gui.entries.TConfigEntryValue;

public class TConfigEntryInt
extends TConfigEntryValue<Integer> {
    private final IntSliderWidget widget;
    private boolean modifiesOffMaxToMin = true;

    public TConfigEntryInt(@Translatable String text, @Translatable String tooltip, Supplier<Integer> getter, Consumer<Integer> setter, int defaultValue, int min, int max, boolean isMinOff, boolean isMaxOff) {
        super(text, tooltip, getter, setter, defaultValue);
        this.widget = new IntSliderWidget(this.getText(), getter.get(), this.getTooltip(), min, max, isMinOff, isMaxOff);
    }

    public TConfigEntryInt(@Translatable String text, @Translatable String tooltip, Supplier<Integer> getter, Consumer<Integer> setter, int defaultValue, int min, int max) {
        super(text, tooltip, getter, setter, defaultValue);
        this.widget = new IntSliderWidget(this.getText(), getter.get(), this.getTooltip(), min, max, false, false);
    }

    public TConfigEntryInt(@Translatable String text, Supplier<Integer> getter, Consumer<Integer> setter, int defaultValue, int min, int max, boolean isMinOff, boolean isMaxOff) {
        this(text, null, getter, setter, defaultValue, min, max, isMinOff, isMaxOff);
    }

    public TConfigEntryInt(@Translatable String text, Supplier<Integer> getter, Consumer<Integer> setter, int defaultValue, int min, int max) {
        this(text, null, getter, setter, defaultValue, min, max, false, false);
    }

    @Override
    protected Integer getValueFromWidget() {
        return this.widget.getValueRoundedToIntBetweenMinMax();
    }

    @Override
    public AbstractWidget getWidget(int x, int y, int width, int height) {
        this.widget.m_252865_(x);
        this.widget.m_253211_(y);
        this.widget.m_93674_(width);
        this.widget.f_93619_ = height;
        return this.widget;
    }

    @Override
    void setWidgetToDefaultValue() {
        this.widget.setValue((Integer)this.defaultValue);
    }

    @Override
    void resetWidgetToInitialValue() {
        this.widget.setValue((Integer)this.getter.get());
    }

    public TConfigEntryInt dontModifyOffMaxValues() {
        this.modifiesOffMaxToMin = false;
        return this;
    }

    public class IntSliderWidget
    extends AbstractSliderButton {
        private final int max;
        private final int min;
        private final String title;
        private final boolean isMinOff;
        private final boolean isMaxOff;
        private final int difference;

        public IntSliderWidget(Component text, int initialValue, Tooltip tooltip, int min, int max, boolean isMinOff, boolean isMaxOff) {
            super(0, 0, 20, 20, text, 0.0);
            this.min = min;
            this.max = max;
            this.isMinOff = isMinOff;
            this.isMaxOff = isMaxOff;
            this.difference = max - min;
            this.title = text.getString() + ": ";
            this.setValue(initialValue);
            this.m_257544_(tooltip);
        }

        private boolean isOff() {
            if (this.isMinOff && this.f_93577_ == 0.0) {
                return true;
            }
            return this.isMaxOff && this.f_93577_ == 1.0;
        }

        private void setValue(int intIndex) {
            this.f_93577_ = (double)(Mth.m_14045_((int)intIndex, (int)this.min, (int)this.max) - this.min) / (double)this.difference;
            this.m_5695_();
        }

        protected void m_5695_() {
            this.snapValueToNearestIndex();
            this.m_93666_(Component.m_130674_((String)(this.title + (this.getValueRoundedToIntBetweenMinMax() != ((Integer)TConfigEntryInt.this.getter.get()).intValue() ? "\u00a7a" : "") + (Serializable)(this.isOff() ? CommonComponents.f_130654_.getString() : Integer.valueOf(this.getValueRoundedToIntBetweenMinMax())))));
        }

        protected void m_5697_() {
        }

        private void snapValueToNearestIndex() {
            this.f_93577_ = (double)((int)Math.round(this.f_93577_ * (double)this.difference)) / (double)this.difference;
        }

        public int getValueRoundedToIntBetweenMinMax() {
            if (this.isOff() && TConfigEntryInt.this.modifiesOffMaxToMin) {
                return this.min;
            }
            return (int)Math.round(this.f_93577_ * (double)this.difference) + this.min;
        }
    }
}

