/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.entity;

import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Event;

public abstract class EntityEventWrapper
extends EventWrapper {
    private final Entity entity;

    public EntityEventWrapper(Entity entity) {
        this.entity = entity;
    }

    public EntityEventWrapper(EntityEvent event) {
        this(event.getEntity());
    }

    public Entity getEntity() {
        return this.entity;
    }

    public static Class<? extends Event> getForgeClass() {
        return EntityEvent.class;
    }

    @Override
    public Object toForgeEvent() {
        return new EntityEvent(this.getEntity());
    }

    public static class EnteringSection
    extends EntityEventWrapper {
        private final long packedOldPos;
        private final long packedNewPos;

        public EnteringSection(Entity entity, long packedOldPos, long packedNewPos) {
            super(entity);
            this.packedOldPos = packedOldPos;
            this.packedNewPos = packedNewPos;
        }

        public EnteringSection(EntityEvent.EnteringSection event) {
            this(event.getEntity(), event.getPackedOldPos(), event.getPackedNewPos());
        }

        public long getPackedOldPos() {
            return this.packedOldPos;
        }

        public long getPackedNewPos() {
            return this.packedNewPos;
        }

        public SectionPos getOldPos() {
            return SectionPos.m_123184_((long)this.packedOldPos);
        }

        public SectionPos getNewPos() {
            return SectionPos.m_123184_((long)this.packedNewPos);
        }

        public boolean didChunkChange() {
            return SectionPos.m_123213_((long)this.packedOldPos) != SectionPos.m_123213_((long)this.packedNewPos) || SectionPos.m_123230_((long)this.packedOldPos) != SectionPos.m_123230_((long)this.packedNewPos);
        }

        public static Class<? extends Event> getForgeClass() {
            return EntityEvent.EnteringSection.class;
        }

        @Override
        public Object toForgeEvent() {
            return new EntityEvent.EnteringSection(this.getEntity(), this.getPackedOldPos(), this.getPackedNewPos());
        }
    }

    public static class EntityConstructing
    extends EntityEventWrapper {
        public EntityConstructing(Entity entity) {
            super(entity);
        }

        public EntityConstructing(EntityEvent.EntityConstructing event) {
            this(event.getEntity());
        }

        public static Class<? extends Event> getForgeClass() {
            return EntityEvent.EntityConstructing.class;
        }

        @Override
        public Object toForgeEvent() {
            return new EntityEvent.EntityConstructing(this.getEntity());
        }
    }
}

