/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.entity.player;

import com.google.common.base.Preconditions;
import io.github.lounode.eventwrapper.event.entity.player.PlayerEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import io.github.lounode.eventwrapper.utils.LogicalSide;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerInteractEventWrapper
extends PlayerEventWrapper {
    private final InteractionHand hand;
    private final BlockPos pos;
    @Nullable
    private final Direction face;
    private InteractionResult cancellationResult = InteractionResult.PASS;

    private PlayerInteractEventWrapper(Player player, InteractionHand hand, BlockPos pos, @Nullable Direction face) {
        super((Player)Preconditions.checkNotNull((Object)player, (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (InteractionHand)Preconditions.checkNotNull((Object)hand, (Object)"Null hand in PlayerInteractEvent!");
        this.pos = (BlockPos)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    @NotNull
    public InteractionHand getHand() {
        return this.hand;
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.getEntity().m_21120_(this.hand);
    }

    @NotNull
    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    public Direction getFace() {
        return this.face;
    }

    public Level getLevel() {
        return this.getEntity().m_9236_();
    }

    public LogicalSide getSide() {
        return this.getLevel().f_46443_ ? LogicalSide.CLIENT : LogicalSide.SERVER;
    }

    public InteractionResult getCancellationResult() {
        return this.cancellationResult;
    }

    public void setCancellationResult(InteractionResult result) {
        this.cancellationResult = result;
    }

    public static Class<? extends Event> getForgeClass() {
        return PlayerInteractEvent.class;
    }

    public PlayerInteractEventWrapper(PlayerInteractEvent event) {
        this(event.getEntity(), event.getHand(), event.getPos(), event.getFace());
    }

    public static class LeftClickEmpty
    extends PlayerInteractEventWrapper {
        public LeftClickEmpty(Player player) {
            super(player, InteractionHand.MAIN_HAND, player.m_20183_(), null);
        }

        public LeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
            super(event.getEntity(), event.getHand(), event.getPos(), event.getFace());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.LeftClickEmpty.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.LeftClickEmpty(this.getEntity());
        }
    }

    @Cancelable
    public static class LeftClickBlock
    extends PlayerInteractEventWrapper {
        private EventWrapper.Result useBlock = EventWrapper.Result.DEFAULT;
        private EventWrapper.Result useItem = EventWrapper.Result.DEFAULT;

        public LeftClickBlock(Player player, BlockPos pos, Direction face) {
            super(player, InteractionHand.MAIN_HAND, pos, face);
        }

        public EventWrapper.Result getUseBlock() {
            return this.useBlock;
        }

        public EventWrapper.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(EventWrapper.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(EventWrapper.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = EventWrapper.Result.DENY;
                this.useItem = EventWrapper.Result.DENY;
            }
        }

        public LeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            this(event.getEntity(), event.getPos(), event.getFace());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.LeftClickBlock.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.LeftClickBlock(this.getEntity(), this.getPos(), this.getFace());
        }

        public static enum Action {
            START,
            STOP,
            ABORT,
            CLIENT_HOLD;


            public static Action convert(ServerboundPlayerActionPacket.Action action) {
                return switch (action) {
                    default -> START;
                    case ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK -> START;
                    case ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK -> STOP;
                    case ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK -> ABORT;
                };
            }
        }
    }

    public static class RightClickEmpty
    extends PlayerInteractEventWrapper {
        public RightClickEmpty(Player player, InteractionHand hand) {
            super(player, hand, player.m_20183_(), null);
        }

        public RightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
            this(event.getEntity(), event.getHand());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.RightClickEmpty.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.RightClickEmpty(this.getEntity(), this.getHand());
        }
    }

    @Cancelable
    public static class RightClickItem
    extends PlayerInteractEventWrapper {
        public RightClickItem(Player player, InteractionHand hand) {
            super(player, hand, player.m_20183_(), null);
        }

        public RightClickItem(PlayerInteractEvent.RightClickItem event) {
            this(event.getEntity(), event.getHand());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.RightClickItem.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.RightClickItem(this.getEntity(), this.getHand());
        }
    }

    @Cancelable
    public static class RightClickBlock
    extends PlayerInteractEventWrapper {
        private EventWrapper.Result useBlock = EventWrapper.Result.DEFAULT;
        private EventWrapper.Result useItem = EventWrapper.Result.DEFAULT;
        private BlockHitResult hitVec;

        public RightClickBlock(Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitVec) {
            super(player, hand, pos, hitVec.m_82434_());
            this.hitVec = hitVec;
        }

        public EventWrapper.Result getUseBlock() {
            return this.useBlock;
        }

        public EventWrapper.Result getUseItem() {
            return this.useItem;
        }

        public BlockHitResult getHitVec() {
            return this.hitVec;
        }

        public void setUseBlock(EventWrapper.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(EventWrapper.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = EventWrapper.Result.DENY;
                this.useItem = EventWrapper.Result.DENY;
            }
        }

        public RightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            this(event.getEntity(), event.getHand(), event.getPos(), event.getHitVec());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.RightClickBlock.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.RightClickBlock(this.getEntity(), this.getHand(), this.getPos(), this.getHitVec());
        }
    }

    @Cancelable
    public static class EntityInteract
    extends PlayerInteractEventWrapper {
        private final Entity target;

        public EntityInteract(Player player, InteractionHand hand, Entity target) {
            super(player, hand, target.m_20183_(), null);
            this.target = target;
        }

        public Entity getTarget() {
            return this.target;
        }

        public EntityInteract(PlayerInteractEvent.EntityInteract event) {
            this(event.getEntity(), event.getHand(), event.getTarget());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.EntityInteract.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.EntityInteract(this.getEntity(), this.getHand(), this.getTarget());
        }
    }

    @Cancelable
    public static class EntityInteractSpecific
    extends PlayerInteractEventWrapper {
        private final Vec3 localPos;
        private final Entity target;

        public EntityInteractSpecific(Player player, InteractionHand hand, Entity target, Vec3 localPos) {
            super(player, hand, target.m_20183_(), null);
            this.localPos = localPos;
            this.target = target;
        }

        public Vec3 getLocalPos() {
            return this.localPos;
        }

        public Entity getTarget() {
            return this.target;
        }

        public EntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
            this(event.getEntity(), event.getHand(), event.getTarget(), event.getLocalPos());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.EntityInteractSpecific.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.EntityInteractSpecific(this.getEntity(), this.getHand(), this.getTarget(), this.getLocalPos());
        }
    }
}

