/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.furnace;

import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

@Cancelable
public class FurnaceFuelBurnTimeEventWrapper
extends EventWrapper {
    private final ItemStack itemStack;
    @Nullable
    private final RecipeType<?> recipeType;
    private int burnTime;

    public FurnaceFuelBurnTimeEventWrapper(ItemStack itemStack, int burnTime, @Nullable RecipeType<?> recipeType) {
        this.itemStack = itemStack;
        this.burnTime = burnTime;
        this.recipeType = recipeType;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Nullable
    public RecipeType<?> getRecipeType() {
        return this.recipeType;
    }

    public void setBurnTime(int burnTime) {
        if (burnTime >= 0) {
            this.burnTime = burnTime;
            this.setCanceled(true);
        }
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public FurnaceFuelBurnTimeEventWrapper(FurnaceFuelBurnTimeEvent event) {
        this(event.getItemStack(), event.getBurnTime(), event.getRecipeType());
    }

    public static Class<? extends Event> getForgeClass() {
        return FurnaceFuelBurnTimeEvent.class;
    }

    @Override
    public Object toForgeEvent() {
        return new FurnaceFuelBurnTimeEvent(this.getItemStack(), this.getBurnTime(), this.getRecipeType());
    }
}

