/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.level;

import com.google.common.collect.ImmutableList;
import io.github.lounode.eventwrapper.EventsWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import io.github.lounode.eventwrapper.utils.BlockSnapshot;
import io.github.lounode.eventwrapper.utils.ToolAction;
import io.github.lounode.xplatform.platform.support.CrossPlatform;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CrossPlatform
public class BlockEventWrapper
extends EventWrapper {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    private final LevelAccessor level;
    private final BlockPos pos;
    private final BlockState state;

    public BlockEventWrapper(LevelAccessor level, BlockPos pos, BlockState state) {
        this.pos = pos;
        this.level = level;
        this.state = state;
    }

    public LevelAccessor getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockEventWrapper(BlockEvent event) {
        this(event.getLevel(), event.getPos(), event.getState());
    }

    public static Class<? extends Event> getForgeClass() {
        return BlockEvent.class;
    }

    @Override
    public Object toForgeEvent() {
        return new BlockEvent(this.getLevel(), this.getPos(), this.getState());
    }

    @CrossPlatform
    @Cancelable
    public static class BlockToolModificationEvent
    extends BlockEventWrapper {
        private final UseOnContext context;
        private final ToolAction toolAction;
        private final boolean simulate;
        private BlockState state;

        public BlockToolModificationEvent(BlockState originalState, @NotNull UseOnContext context, ToolAction toolAction, boolean simulate) {
            super((LevelAccessor)context.m_43725_(), context.m_8083_(), originalState);
            this.context = context;
            this.state = originalState;
            this.toolAction = toolAction;
            this.simulate = simulate;
        }

        @Nullable
        public Player getPlayer() {
            return this.context.m_43723_();
        }

        public ItemStack getHeldItemStack() {
            return this.context.m_43722_();
        }

        public ToolAction getToolAction() {
            return this.toolAction;
        }

        public boolean isSimulated() {
            return this.simulate;
        }

        @NotNull
        public UseOnContext getContext() {
            return this.context;
        }

        public void setFinalState(@Nullable BlockState finalState) {
            this.state = finalState;
        }

        public BlockState getFinalState() {
            return this.state;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEventWrapper {
        private final PortalShape size;

        public PortalSpawnEvent(LevelAccessor level, BlockPos pos, BlockState state, PortalShape size) {
            super(level, pos, state);
            this.size = size;
        }

        public PortalShape getPortalSize() {
            return this.size;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class FarmlandTrampleEvent
    extends BlockEventWrapper {
        private final Entity entity;
        private final float fallDistance;

        public FarmlandTrampleEvent(Level level, BlockPos pos, BlockState state, float fallDistance, Entity entity) {
            super((LevelAccessor)level, pos, state);
            this.entity = entity;
            this.fallDistance = fallDistance;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public float getFallDistance() {
            return this.fallDistance;
        }
    }

    @CrossPlatform
    public static class CropGrowEvent
    extends BlockEventWrapper {
        public CropGrowEvent(Level level, BlockPos pos, BlockState state) {
            super((LevelAccessor)level, pos, state);
        }

        @CrossPlatform
        public static class Post
        extends CropGrowEvent {
            private final BlockState originalState;

            public Post(Level level, BlockPos pos, BlockState original, BlockState state) {
                super(level, pos, state);
                this.originalState = original;
            }

            public BlockState getOriginalState() {
                return this.originalState;
            }
        }

        @CrossPlatform
        @EventWrapper.HasResult
        public static class Pre
        extends CropGrowEvent {
            public Pre(Level level, BlockPos pos, BlockState state) {
                super(level, pos, state);
            }
        }
    }

    @CrossPlatform
    @Cancelable
    public static class FluidPlaceBlockEvent
    extends BlockEventWrapper {
        private final BlockPos liquidPos;
        private BlockState newState;
        private BlockState origState;

        public FluidPlaceBlockEvent(LevelAccessor level, BlockPos pos, BlockPos liquidPos, BlockState state) {
            super(level, pos, state);
            this.liquidPos = liquidPos;
            this.newState = state;
            this.origState = level.m_8055_(pos);
        }

        public BlockPos getLiquidPos() {
            return this.liquidPos;
        }

        public BlockState getNewState() {
            return this.newState;
        }

        public void setNewState(BlockState state) {
            this.newState = state;
        }

        public BlockState getOriginalState() {
            return this.origState;
        }
    }

    @CrossPlatform
    @EventWrapper.HasResult
    public static class CreateFluidSourceEvent
    extends EventWrapper {
        private final Level level;
        private final BlockPos pos;
        private final BlockState state;

        public CreateFluidSourceEvent(Level level, BlockPos pos, BlockState state) {
            this.level = level;
            this.pos = pos;
            this.state = state;
        }

        public Level getLevel() {
            return this.level;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getState() {
            return this.state;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEventWrapper {
        private final EnumSet<Direction> notifiedSides;
        private final boolean forceRedstoneUpdate;

        public NeighborNotifyEvent(Level level, BlockPos pos, BlockState state, EnumSet<Direction> notifiedSides, boolean forceRedstoneUpdate) {
            super((LevelAccessor)level, pos, state);
            this.notifiedSides = notifiedSides;
            this.forceRedstoneUpdate = forceRedstoneUpdate;
        }

        public EnumSet<Direction> getNotifiedSides() {
            return this.notifiedSides;
        }

        public boolean getForceRedstoneUpdate() {
            return this.forceRedstoneUpdate;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class EntityMultiPlaceEvent
    extends EntityPlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public EntityMultiPlaceEvent(@NotNull List<BlockSnapshot> blockSnapshots, @NotNull BlockState placedAgainst, @Nullable Entity entity) {
            super(blockSnapshots.get(0), placedAgainst, entity);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class EntityPlaceEvent
    extends BlockEventWrapper {
        private final Entity entity;
        private final BlockSnapshot blockSnapshot;
        private final BlockState placedBlock;
        private final BlockState placedAgainst;

        public EntityPlaceEvent(@NotNull BlockSnapshot blockSnapshot, @NotNull BlockState placedAgainst, @Nullable Entity entity) {
            super(blockSnapshot.getLevel(), blockSnapshot.getPos(), !(entity instanceof Player) ? blockSnapshot.getReplacedBlock() : blockSnapshot.getCurrentBlock());
            this.entity = entity;
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = !(entity instanceof Player) ? blockSnapshot.getReplacedBlock() : blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
        }

        @Nullable
        public Entity getEntity() {
            return this.entity;
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public BlockState getPlacedBlock() {
            return this.placedBlock;
        }

        public BlockState getPlacedAgainst() {
            return this.placedAgainst;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class BreakEvent
    extends BlockEventWrapper {
        private final Player player;
        private int exp;

        public BreakEvent(Level level, BlockPos pos, BlockState state, Player player) {
            super((LevelAccessor)level, pos, state);
            this.player = player;
            if (state == null || !EventsWrapper.getInstance().getHelper().isCorrectToolForDrops(state, player)) {
                this.exp = 0;
            } else {
                ItemStack stack = player.m_21205_();
                int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack);
                int n = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack);
            }
        }

        public Player getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }
}

