/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.eventbus.api;

import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.LockHelper;
import java.lang.annotation.Annotation;
import java.util.IdentityHashMap;

public class EventListenerHelper {
    private static final LockHelper<Class<?>, Boolean> cancelable = new LockHelper(new IdentityHashMap());
    private static final LockHelper<Class<?>, Boolean> hasResult = new LockHelper(new IdentityHashMap());

    static boolean isCancelable(Class<?> eventClass) {
        return EventListenerHelper.hasAnnotation(eventClass, Cancelable.class, cancelable);
    }

    static boolean hasResult(Class<?> eventClass) {
        return EventListenerHelper.hasAnnotation(eventClass, EventWrapper.HasResult.class, hasResult);
    }

    private static boolean hasAnnotation(Class<?> eventClass, Class<? extends Annotation> annotation, LockHelper<Class<?>, Boolean> lock) {
        if (eventClass == EventWrapper.class) {
            return false;
        }
        return lock.computeIfAbsent(eventClass, () -> {
            Class parent = eventClass.getSuperclass();
            return eventClass.isAnnotationPresent(annotation) || parent != null && EventListenerHelper.hasAnnotation(parent, annotation, lock);
        });
    }
}

