/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.forge;

import com.mojang.logging.LogUtils;
import io.github.lounode.eventwrapper.forge.AutoEventSubscriberRegistry;
import java.util.List;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

@Mod(value="eventwrapper")
public class ForgeCommonInitializer {
    public static final String MOD_ID = "eventwrapper";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Type MOD_TYPE = Type.getType(Mod.class);

    public ForgeCommonInitializer() {
        List modInfos = ModList.get().getMods();
        for (IModInfo modInfo : modInfos) {
            boolean dependOnSelf = modInfo.getDependencies().stream().anyMatch(dep -> dep.getModId().equals(MOD_ID));
            boolean isSelf = modInfo.getModId().equals(MOD_ID);
            if (!dependOnSelf && !isSelf) continue;
            AutoEventSubscriberRegistry.inject(modInfo.getModId());
        }
    }

    public static boolean isDebugVersion() {
        String debugProperty = System.getProperty("debugEvent");
        return "true".equals(debugProperty);
    }
}

