/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.forge;

import io.github.lounode.eventwrapper.eventbus.api.EventConverter;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.IPlatformEventHelper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.eventwrapper.forge.event.ForgeEventMappings;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeEventHelper
implements IPlatformEventHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public boolean isForge() {
        return true;
    }

    @Override
    public <T extends EventWrapper> T post(T event) {
        EventConverter<?, ?> converter = ForgeEventMappings.getConverter(event.getClass());
        if (converter == null) {
            LOGGER.error("Can't find the converter: {}", event.getClass());
            return event;
        }
        Event forgeEvent = (Event)converter.toEvent(event);
        MinecraftForge.EVENT_BUS.post(forgeEvent);
        return event;
    }

    static Class<? extends Event> getForgeEventClass(Class<? extends EventWrapper> wrapperClass) {
        String wrapperFullName = wrapperClass.getName();
        if (wrapperFullName.contains("Wrapper")) {
            try {
                String forgeClassName = wrapperFullName.replace("Wrapper", "");
                forgeClassName = forgeClassName.replace("io.github.lounode.eventwrapper", "net.minecraftforge");
                Class<?> forgeClass = Class.forName(forgeClassName);
                return forgeClass;
            }
            catch (ClassNotFoundException forgeClassName) {
                // empty catch block
            }
        }
        try {
            Method getForgeClassMethod = wrapperClass.getMethod("getForgeClass", new Class[0]);
            Class forgeClass = (Class)getForgeClassMethod.invoke(null, new Object[0]);
            return forgeClass;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get forge class from wrapper: " + wrapperClass.getName(), e);
        }
    }

    private void registerListener(Object target, Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1) {
            throw new IllegalArgumentException("Event subscriber can only subscribe one event!");
        }
        if (!EventWrapper.class.isAssignableFrom(params[0])) {
            throw new IllegalArgumentException("EventType must extend EventWrapper");
        }
        Class<?> wrapperClass = params[0];
        EventConverter<?, ?> converter = ForgeEventMappings.getConverter(wrapperClass);
        if (converter == null) {
            LOGGER.error("Can't find the converter: {}", wrapperClass);
            return;
        }
        Class<? extends Event> forgeEventClass = ForgeEventMappings.getForgeEventClass(wrapperClass);
        if (forgeEventClass == null) {
            LOGGER.error("Wrapper was not found forge event class: {}", wrapperClass);
            return;
        }
        SubscribeEventWrapper annotation = method.getAnnotation(SubscribeEventWrapper.class);
        EventPriority priority = annotation != null ? EventPriority.valueOf((String)annotation.priority().name()) : EventPriority.NORMAL;
        boolean receiveCanceled = annotation != null && annotation.receiveCanceled();
        method.setAccessible(true);
        MinecraftForge.EVENT_BUS.addListener(priority, receiveCanceled, forgeEventClass, event -> {
            try {
                Object wrapper = converter.toWrapper(event);
                method.invoke(target, wrapper);
                IPlatformEventHelper.syncEventData(wrapper, event);
            }
            catch (Exception e) {
                throw new RuntimeException("Event call Error!", e);
            }
        });
    }

    @Override
    public void register(Object target) {
        boolean isStatic = target.getClass() == Class.class;
        Class<?> clazz = isStatic ? (Class<?>)target : target.getClass();
        ForgeEventHelper.checkSupertypes(clazz, clazz);
        int foundMethods = 0;
        if (clazz.isAnnotationPresent(OnlyIn.class) && clazz.getAnnotation(OnlyIn.class).value() == Dist.CLIENT && FMLEnvironment.dist != Dist.CLIENT) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(SubscribeEventWrapper.class)) continue;
            if (method.isAnnotationPresent(OnlyIn.class) && method.getAnnotation(OnlyIn.class).value() == Dist.CLIENT && FMLEnvironment.dist != Dist.CLIENT) {
                return;
            }
            if (Modifier.isStatic(method.getModifiers()) != isStatic) {
                if (isStatic) {
                    throw new IllegalArgumentException("Expected @SubscribeEvent method %s to be static\nbecause register() was called with a class type.\nEither make the method static, or call register() with an instance of %s.\n".formatted(method, clazz));
                }
                throw new IllegalArgumentException("Expected @SubscribeEvent method %s to NOT be static\nbecause register() was called with an instance type.\nEither make the method non-static, or call register(%s.class).\n".formatted(method, clazz.getSimpleName()));
            }
            this.registerListener(target, method);
            ++foundMethods;
        }
        if (foundMethods == 0) {
            throw new IllegalArgumentException("%s has no @SubscribeEvent methods, but register was called anyway.\nThe event bus only recognizes listener methods that have the @SubscribeEvent annotation.\n".formatted(clazz));
        }
    }

    @Override
    public void unregister(Object object) {
        MinecraftForge.EVENT_BUS.unregister(object);
    }

    private static void checkSupertypes(Class<?> registeredType, Class<?> type) {
        if (type == null || type == Object.class) {
            return;
        }
        if (type != registeredType) {
            for (Method method : type.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(SubscribeEventWrapper.class)) continue;
                throw new IllegalArgumentException("Attempting to register a listener object of type %s,\nhowever its supertype %s has a @SubscribeEvent method: %s.\nThis is not allowed! Only the listener object can have @SubscribeEvent methods.\n".formatted(registeredType, type, method));
            }
        }
        ForgeEventHelper.checkSupertypes(registeredType, type.getSuperclass());
        Stream.of(type.getInterfaces()).forEach(itf -> ForgeEventHelper.checkSupertypes(registeredType, itf));
    }

    @Override
    public boolean isCorrectToolForDrops(BlockState state, Player player) {
        return ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player);
    }
}

