/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.xplatform.platform;

import com.mojang.serialization.Codec;
import io.github.lounode.xplatform.platform.support.CrossPlatform;
import io.github.lounode.xplatform.platform.support.SupportPlatform;
import io.github.lounode.xplatform.platform.support.SupportPlatforms;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.util.StringRepresentable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public enum Platform implements StringRepresentable
{
    FORGE("forge"),
    FABRIC("fabric"),
    NEOFORGE("neoforge"),
    QUILT("quilt"),
    UNKNOWN("unknown");

    public static final Codec<Platform> CODEC;
    private final String key;
    private static final String CROSS_PLATFORM_DESCRIPTOR;
    private static final String SUPPORT_PLATFORM_DESCRIPTOR;
    private static final String SUPPORT_PLATFORMS_DESCRIPTOR;

    private Platform(String key) {
        this.key = key;
    }

    public String m_7912_() {
        return this.key;
    }

    public static Platform getCurrent() {
        try {
            Class.forName("net.minecraftforge.fml.loading.FMLLoader");
            return FORGE;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("net.neoforged.fml.loading.FMLLoader");
                return NEOFORGE;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    Class.forName("net.fabricmc.loader.api.FabricLoader");
                    return FABRIC;
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    try {
                        Class.forName("org.quiltmc.loader.api.QuiltLoader");
                        return QUILT;
                    }
                    catch (ClassNotFoundException classNotFoundException4) {
                        return UNKNOWN;
                    }
                }
            }
        }
    }

    public static Platform[] getCurrents() {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        try {
            Class.forName("net.minecraftforge.fml.loading.FMLLoader");
            platforms.add(FORGE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("net.neoforged.fml.loading.FMLLoader");
            platforms.add(NEOFORGE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("net.fabricmc.loader.api.FabricLoader");
            platforms.add(FABRIC);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("org.quiltmc.loader.api.QuiltLoader");
            platforms.add(QUILT);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return platforms.toArray(new Platform[0]);
    }

    public static boolean isSupport(String className) {
        try {
            final AtomicBoolean support = new AtomicBoolean();
            final LinkedHashSet supportedPlatforms = new LinkedHashSet();
            Platform[] currentPlatforms = Platform.getCurrents();
            ClassReader reader = new ClassReader(className);
            final AnnotationVisitor av = new AnnotationVisitor(589824){

                public void visit(String name, Object value) {
                    if (CROSS_PLATFORM_DESCRIPTOR.equals(name)) {
                        support.set(true);
                    }
                }
            };
            reader.accept(new ClassVisitor(589824){

                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    if (descriptor.equals(CROSS_PLATFORM_DESCRIPTOR)) {
                        support.set(true);
                    } else {
                        if (descriptor.equals(SUPPORT_PLATFORM_DESCRIPTOR)) {
                            return new AnnotationVisitor(589824, av){

                                public void visitEnum(String name, String desc, String value) {
                                    if ("value".equals(name)) {
                                        supportedPlatforms.add(Platform.valueOf(value));
                                    }
                                }
                            };
                        }
                        if (descriptor.equals(SUPPORT_PLATFORMS_DESCRIPTOR)) {
                            return new AnnotationVisitor(589824, av){

                                public AnnotationVisitor visitArray(String name) {
                                    if ("value".equals(name)) {
                                        return new AnnotationVisitor(589824, this){

                                            public void visitEnum(String name, String desc, String value) {
                                                supportedPlatforms.add(Platform.valueOf(value));
                                            }
                                        };
                                    }
                                    return this;
                                }
                            };
                        }
                    }
                    return av;
                }
            }, 7);
            if (support.get()) {
                return true;
            }
            for (Platform platform : currentPlatforms) {
                if (!supportedPlatforms.contains((Object)platform)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    static {
        CODEC = StringRepresentable.m_216439_(Platform::values);
        CROSS_PLATFORM_DESCRIPTOR = "L" + CrossPlatform.class.getName().replace('.', '/') + ";";
        SUPPORT_PLATFORM_DESCRIPTOR = "L" + SupportPlatform.class.getName().replace('.', '/') + ";";
        SUPPORT_PLATFORMS_DESCRIPTOR = "L" + SupportPlatforms.class.getName().replace('.', '/') + ";";
    }
}

