/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.api.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class PlayerNameHelper {
    private static final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private static final Map<String, FailureEntry> failureTimes = new ConcurrentHashMap<String, FailureEntry>();
    private static final Duration CACHE_DURATION = Duration.ofMinutes(15L);
    private static final int MAX_FAILURES = 5;

    public static String getPlayerNameFromUUID(String uuid) {
        boolean isCacheExpired;
        CacheEntry entry = cache.get(uuid);
        boolean bl = isCacheExpired = entry == null || entry.isExpired();
        if (!isCacheExpired) {
            return entry.name;
        }
        try {
            String inputLine;
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            JsonObject jsonObject = JsonParser.parseString((String)content.toString()).getAsJsonObject();
            if (jsonObject.has("name")) {
                String name = jsonObject.get("name").getAsString();
                cache.put(uuid, new CacheEntry(name));
                failureTimes.remove(uuid);
                return name;
            }
            return PlayerNameHelper.SaveFailureData(uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return PlayerNameHelper.SaveFailureData(uuid);
        }
    }

    @Nullable
    private static String SaveFailureData(String uuid) {
        PlayerNameHelper.recordFailureTime(uuid);
        FailureEntry failureEntry = failureTimes.getOrDefault(uuid, new FailureEntry());
        if (failureEntry.failures >= 5) {
            cache.put(uuid, new CacheEntry(uuid));
            failureTimes.remove(uuid);
            return uuid;
        }
        return null;
    }

    private static void recordFailureTime(String uuid) {
        FailureEntry failureEntry = failureTimes.computeIfAbsent(uuid, k -> new FailureEntry());
        ++failureEntry.failures;
        failureEntry.lastFailureTime = Instant.now();
    }

    private static class CacheEntry {
        final String name;
        final Instant creationTime;

        CacheEntry(String name) {
            this.name = name;
            this.creationTime = Instant.now();
        }

        boolean isExpired() {
            return Instant.now().isAfter(this.creationTime.plus(CACHE_DURATION));
        }
    }

    private static class FailureEntry {
        int failures = 0;
        Instant lastFailureTime = Instant.now();

        private FailureEntry() {
        }
    }
}

