/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.api.gaia;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtend;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtendBuilder;
import io.github.lounode.extrabotany.api.gaia.BlockTagPredicate;
import io.github.lounode.extrabotany.common.entity.MagicLandMineEntity;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import io.github.lounode.extrabotany.common.lib.RegistryHelper;
import io.github.lounode.extrabotany.common.telemetry.ExtraBotanyTelemetry;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.entity.MagicLandmineEntity;
import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.proxy.Proxy;

public class GaiaArena {
    public static final Codec<GaiaArena> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.f_122633_.fieldOf("center").forGetter(GaiaArena::center), (App)Codec.FLOAT.fieldOf("radius").forGetter(GaiaArena::radius), (App)Codec.INT.fieldOf("height").forGetter(GaiaArena::height)).apply((Applicative)instance, GaiaArena::of));
    public static final float ARENA_RANGE = 12.0f;
    public static final int ARENA_HEIGHT = 5;
    private static final TagKey<Block> BLACKLIST = BotaniaTags.Blocks.GAIA_BREAK_BLACKLIST;
    public static final List<BlockPos> PYLON_LOCATIONS = ImmutableList.of((Object)new BlockPos(4, 1, 4), (Object)new BlockPos(4, 1, -4), (Object)new BlockPos(-4, 1, 4), (Object)new BlockPos(-4, 1, -4));
    public static final Predicate<BlockInWorld>[][][] ARENA_PATTERN = BlockPatternExtendBuilder.start().aisle("P_______P", "_________", "_________", "_________", "_________", "_________", "_________", "_________", "P_______P").aisle("_________", "_________", "_________", "_________", "____B____", "_________", "_________", "_________", "_________").aisle("_________", "_________", "_________", "___III___", "___III___", "___III___", "_________", "_________", "_________").where('_', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.f_61281_)).where('B', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50273_))).where('I', BlockInWorld.m_61169_((Predicate)BlockTagPredicate.forTag((TagKey<Block>)BlockTags.f_13079_))).where('P', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)BotaniaBlocks.gaiaPylon))).createPattern();
    public static final Predicate<BlockInWorld>[][][] PYLONS_PATTERN = BlockPatternExtendBuilder.start().aisle("P_______P", "_________", "_________", "_________", "_________", "_________", "_________", "_________", "P_______P").where('_', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.f_61281_)).where('P', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)BotaniaBlocks.gaiaPylon))).createPattern();
    private static List<String> CACHED_BYPASS_CONFIG = new ArrayList<String>();
    private static final List<String> CACHED_BYPASS_MODIDS = new ArrayList<String>();
    private static final List<String> CACHED_BYPASS_ITEMS = new ArrayList<String>();
    private final GlobalPos center;
    private final float radius;
    private final int height;

    private GaiaArena(GlobalPos center, float radius, int height) {
        this.center = center;
        this.radius = radius;
        this.height = height;
    }

    public static GaiaArena of(GlobalPos center, float radius, int height) {
        return new GaiaArena(center, radius, height);
    }

    public static GaiaArena of(GlobalPos center) {
        return GaiaArena.of(center, 12.0f, 5);
    }

    public GlobalPos center() {
        return this.center;
    }

    public float radius() {
        return this.radius;
    }

    public int height() {
        return this.height;
    }

    public boolean isSameCenter(GaiaArena other) {
        return this.center.equals((Object)other.center);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            GaiaArena gaiaArena = (GaiaArena)other;
            return Objects.equals(this.center, gaiaArena.center) && Objects.equals(Float.valueOf(this.radius), Float.valueOf(gaiaArena.radius)) && Objects.equals(this.height, gaiaArena.height);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.center, Float.valueOf(this.radius), this.height);
    }

    public String toString() {
        return "GaiaArena{center=" + String.valueOf(this.center) + ", radius=" + this.radius + ", height=" + this.height + "}";
    }

    public void tick(Gaia gaia) {
        List<Player> players;
        if (gaia.m_9236_().m_5776_()) {
            this.particles(gaia);
        }
        if ((players = this.getPlayersAround(gaia.m_9236_())).isEmpty() && !gaia.m_9236_().m_6907_().isEmpty()) {
            gaia.m_146870_();
            ExtraBotanyTelemetry.Event.onGaiaBattleFinish(gaia);
        }
        if (!gaia.m_9236_().m_5776_()) {
            for (Player player : players) {
                this.keepInsideArena(player);
            }
        }
    }

    public void cleanup(Level level) {
        if (level.m_5776_()) {
            return;
        }
        for (Player player : this.getPlayersAround(level)) {
            if (player.m_21124_(MobEffects.f_19615_) == null) continue;
            player.m_21195_(MobEffects.f_19615_);
        }
        for (PixieEntity pixie : level.m_6443_(PixieEntity.class, this.getArenaBB(), p -> p.m_6084_() && p.getPixieType() == 1)) {
            pixie.m_21373_();
            pixie.m_146870_();
        }
        for (MagicLandmineEntity landmine : level.m_45976_(MagicLandmineEntity.class, this.getArenaBB())) {
            landmine.m_146870_();
        }
        for (MagicLandMineEntity mine : level.m_45976_(MagicLandMineEntity.class, this.getArenaBB())) {
            mine.m_146870_();
        }
    }

    public void keepInsideArena(Player player) {
        if (MathHelper.pointDistanceSpace((double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (double)((double)this.center().m_122646_().m_123341_() + 0.5), (double)((double)this.center().m_122646_().m_123342_() + 0.5), (double)((double)this.center().m_122646_().m_123343_() + 0.5)) >= this.radius()) {
            Vec3 sourceVector = new Vec3((double)this.center().m_122646_().m_123341_() + 0.5, (double)this.center().m_122646_().m_123342_() + 0.5, (double)this.center().m_122646_().m_123343_() + 0.5);
            Vec3 playerVector = VecHelper.fromEntityCenter((Entity)player);
            Vec3 motion = sourceVector.m_82546_(playerVector).m_82541_();
            player.m_20334_(motion.f_82479_, 0.2, motion.f_82481_);
            player.f_19864_ = true;
        }
    }

    public void particles(Gaia gaia) {
        float rad;
        for (int i = 0; i < 360; i += 8) {
            float r = 0.6f;
            float g = 0.0f;
            float b = 0.2f;
            float m = 0.15f;
            float mv = 0.35f;
            rad = (float)i * (float)Math.PI / 180.0f;
            double x = (double)this.center().m_122646_().m_123341_() + 0.5 - Math.cos(rad) * (double)this.radius();
            double y = (double)this.center().m_122646_().m_123342_() + 0.5;
            double z = (double)this.center().m_122646_().m_123343_() + 0.5 - Math.sin(rad) * (double)this.radius();
            WispParticleData data = WispParticleData.wisp((float)0.5f, (float)r, (float)g, (float)b);
            gaia.m_9236_().m_7106_((ParticleOptions)data, x, y, z, (double)((float)(Math.random() - 0.5) * m), (double)((float)(Math.random() - 0.5) * mv), (double)((float)(Math.random() - 0.5) * m));
        }
        if (gaia.getInvulTime() > 10) {
            Vec3 pos = VecHelper.fromEntityCenter((Entity)gaia).m_82492_(0.0, 0.2, 0.0);
            for (BlockPos arr : PYLON_LOCATIONS) {
                Vec3 pylonPos = new Vec3((double)(this.center().m_122646_().m_123341_() + arr.m_123341_()), (double)(this.center().m_122646_().m_123342_() + arr.m_123342_()), (double)(this.center().m_122646_().m_123343_() + arr.m_123343_()));
                double worldTime = gaia.f_19797_;
                rad = 0.75f + (float)Math.random() * 0.05f;
                double xp = pylonPos.f_82479_ + 0.5 + Math.cos(worldTime /= 5.0) * (double)rad;
                double zp = pylonPos.f_82481_ + 0.5 + Math.sin(worldTime) * (double)rad;
                Vec3 partPos = new Vec3(xp, pylonPos.f_82480_, zp);
                Vec3 mot = pos.m_82546_(partPos).m_82490_(0.04);
                float r = 0.7f + (float)Math.random() * 0.3f;
                float g = (float)Math.random() * 0.3f;
                float b = 0.7f + (float)Math.random() * 0.3f;
                WispParticleData data = WispParticleData.wisp((float)(0.25f + (float)Math.random() * 0.1f), (float)r, (float)g, (float)b, (float)1.0f);
                gaia.m_9236_().m_7106_((ParticleOptions)data, partPos.f_82479_, partPos.f_82480_, partPos.f_82481_, 0.0, (double)(-(-0.075f - (float)Math.random() * 0.015f)), 0.0);
                WispParticleData data1 = WispParticleData.wisp((float)0.4f, (float)r, (float)g, (float)b);
                gaia.m_9236_().m_7106_((ParticleOptions)data1, partPos.f_82479_, partPos.f_82480_, partPos.f_82481_, (double)((float)mot.f_82479_), (double)((float)mot.f_82480_), (double)((float)mot.f_82481_));
            }
        }
    }

    public boolean checksVanilla(Player player, Level world, BlockPos pos) {
        if (!(world.m_7702_(pos) instanceof BeaconBlockEntity) || !PlayerHelper.isTruePlayer((Entity)player) || this.countGaiaAround(world, GaiaGuardianEntity.class) > 0) {
            return false;
        }
        if (!GaiaArena.checkDifficulty(world)) {
            if (!world.m_5776_()) {
                player.m_213846_((Component)Component.m_237115_((String)"botaniamisc.peacefulNoob").m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        if (!this.checkPylons(player, world)) {
            return false;
        }
        List<BlockPos> invalidArenaBlocks = this.checkArea(world);
        if (!invalidArenaBlocks.isEmpty()) {
            if (world.f_46443_) {
                GaiaArena.warnInvalidBlocks(world, invalidArenaBlocks);
                this.showRadius(world);
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"botaniamisc.badArena").m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        return true;
    }

    public boolean checksModern(Player player, Level world, ItemStack stack) {
        List<BlockPos> invalidArenaBlocks;
        if (!(world.m_7702_(this.center().m_122646_()) instanceof BeaconBlockEntity) || !PlayerHelper.isTruePlayer((Entity)player) || this.countGaiaAround(world, Gaia.class) + this.countGaiaAround(world, GaiaGuardianEntity.class) > 0) {
            return false;
        }
        if (!GaiaArena.checkDifficulty(world)) {
            if (!world.m_5776_()) {
                player.m_213846_((Component)Component.m_237115_((String)"botaniamisc.peacefulNoob").m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        if (world.m_5776_()) {
            if (!this.checkStructure(world, ARENA_PATTERN)) {
                return false;
            }
        } else {
            BlockPatternExtend.MatchResult result = this.checkStructureNeedsMatchResult(world, ARENA_PATTERN);
            if (result instanceof BlockPatternExtend.BlockPatternMatchFail) {
                BlockPatternExtend.BlockPatternMatchFail fail = (BlockPatternExtend.BlockPatternMatchFail)result;
                if (!world.m_5776_()) {
                    List<BlockPos> invalidPylonBlocks = fail.getFailedBlocks().keySet().stream().toList();
                    GaiaArena.warnInvalidBlocksServer((ServerPlayer)player, (ServerLevel)world, invalidPylonBlocks);
                    player.m_213846_((Component)Component.m_237110_((String)"message.extrabotany.chat.bad_struct", (Object[])new Object[]{stack.m_41720_().m_41466_()}).m_130940_(ChatFormatting.RED));
                }
                return false;
            }
        }
        if (!(invalidArenaBlocks = this.checkArea(world)).isEmpty()) {
            if (world.f_46443_) {
                GaiaArena.warnInvalidBlocks(world, invalidArenaBlocks);
                this.showRadius(world);
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"botaniamisc.badArena").m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        return true;
    }

    public static boolean checkDifficulty(Level world) {
        return world.m_46791_() != Difficulty.PEACEFUL;
    }

    public boolean checkPylons(Player player, Level world) {
        return GaiaArena.checkPylons(player, world, this.center().m_122646_(), PYLON_LOCATIONS);
    }

    public static boolean checkPylons(Player player, Level world, BlockPos beaconPos, List<BlockPos> pylonLocations) {
        List<BlockPos> invalidPylonBlocks = GaiaArena.getInvalidPylons(world, beaconPos, pylonLocations);
        if (!invalidPylonBlocks.isEmpty()) {
            if (world.m_5776_()) {
                GaiaArena.warnInvalidBlocks(world, invalidPylonBlocks);
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"botaniamisc.needsCatalysts").m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        return true;
    }

    public boolean checkStructure(Level world, Predicate<BlockInWorld>[][][] pattern) {
        return GaiaArena.checkStructure(world, this.center().m_122646_(), pattern);
    }

    public static boolean checkStructure(Level world, BlockPos beaconPos, Predicate<BlockInWorld>[][][] pattern) {
        return new BlockPatternExtend(pattern).findFlat((LevelReader)world, beaconPos) != null;
    }

    public BlockPatternExtend.MatchResult checkStructureNeedsMatchResult(Level world, Predicate<BlockInWorld>[][][] pattern) {
        return GaiaArena.checkStructureNeedsMatchResult(world, this.center().m_122646_(), pattern);
    }

    public static BlockPatternExtend.MatchResult checkStructureNeedsMatchResult(Level world, BlockPos beaconPos, Predicate<BlockInWorld>[][][] pattern) {
        return new BlockPatternExtend(pattern).findFlatWithFailResult((LevelReader)world, beaconPos);
    }

    public List<BlockPos> checkArea(Level world) {
        return GaiaArena.checkArena(world, this.center().m_122646_(), this.radius(), this.height(), BLACKLIST);
    }

    public static List<BlockPos> checkArena(Level world, BlockPos beaconPos, float arenaRange, float arenaHeight, TagKey<Block> blackList) {
        return GaiaArena.getInvalidArenaBlocks(world, beaconPos, arenaRange, arenaHeight, blackList);
    }

    public static List<BlockPos> getInvalidArenaBlocks(Level world, BlockPos beaconPos, float arenaRange, float arenaHeight, TagKey<Block> blackList) {
        ArrayList<BlockPos> trippedPositions = new ArrayList<BlockPos>();
        int range = (int)Math.ceil(arenaRange);
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) == 4 && Math.abs(z) == 4 || MathHelper.pointDistancePlane((double)x, (double)z, (double)0.0, (double)0.0) > arenaRange) continue;
                boolean hasFloor = false;
                int y = -2;
                while ((float)y <= arenaHeight) {
                    if (x != 0 || y != 0 || z != 0) {
                        boolean isBlockHere;
                        BlockPos pos = beaconPos.m_7918_(x, y, z);
                        BlockState state = world.m_8055_(pos);
                        boolean allowBlockHere = y < 0;
                        boolean bl = isBlockHere = !state.m_60812_((BlockGetter)world, pos).m_83281_();
                        if (allowBlockHere && isBlockHere) {
                            hasFloor = true;
                        }
                        if (y == 0 && !hasFloor) {
                            trippedPositions.add(pos.m_7495_());
                        }
                        if (!allowBlockHere && isBlockHere && !state.m_204336_(blackList)) {
                            trippedPositions.add(pos);
                        }
                    }
                    ++y;
                }
            }
        }
        return trippedPositions;
    }

    public boolean checkInventory(Level level) {
        List<Player> players = this.getPlayersAround(level);
        for (Player player : players) {
            if (GaiaArena.checkInventoryPass(player)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkInventoryPass(Player player) {
        if (player.m_7500_() || ExtraBotanyConfig.common().disableGaiaDisArm()) {
            return true;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (GaiaArena.checkFeasibility(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFeasibility(ItemStack stack) {
        ResourceLocation itemLocation;
        String modid;
        if (stack.m_41619_()) {
            return true;
        }
        if (CACHED_BYPASS_CONFIG != ExtraBotanyConfig.common().gaiaSpawnUnCheckList()) {
            GaiaArena.updateCache(ExtraBotanyConfig.common().gaiaSpawnUnCheckList());
        }
        if (CACHED_BYPASS_MODIDS.contains(modid = (itemLocation = RegistryHelper.getRegistryName(stack.m_41720_())).m_135827_())) {
            return true;
        }
        return CACHED_BYPASS_ITEMS.contains(itemLocation.toString());
    }

    public static void updateCache(List<String> newBypassList) {
        CACHED_BYPASS_CONFIG = newBypassList;
        CACHED_BYPASS_MODIDS.clear();
        CACHED_BYPASS_ITEMS.clear();
        for (String s : CACHED_BYPASS_CONFIG) {
            if (!s.contains(":")) {
                CACHED_BYPASS_MODIDS.add(s);
                continue;
            }
            ResourceLocation itemLocation = ResourceLocation.m_135820_((String)s);
            if (itemLocation == null || !BuiltInRegistries.f_257033_.m_7804_(itemLocation)) continue;
            CACHED_BYPASS_ITEMS.add(itemLocation.toString());
        }
    }

    public int countGaiaAround(Level world, Class<? extends Entity> gaiaClass) {
        return world.m_45976_(gaiaClass, this.getArenaBB()).size();
    }

    public static int countGaiaAround(Level world, BlockPos center, float radius, Class<? extends Entity> gaiaClass) {
        return world.m_45976_(gaiaClass, GaiaArena.getArenaBB(center, radius)).size();
    }

    @NotNull
    public AABB getArenaBB() {
        return this.getArenaBB(this.radius());
    }

    @NotNull
    public AABB getArenaBB(double radius) {
        return GaiaArena.getArenaBB(this.center().m_122646_(), radius);
    }

    @NotNull
    public static AABB getArenaBB(BlockPos center, double radius) {
        return new AABB((double)center.m_123341_() + 0.5, (double)center.m_123342_() + 0.5, (double)center.m_123343_() + 0.5, (double)center.m_123341_() + 0.5, (double)center.m_123342_() + 0.5, (double)center.m_123343_() + 0.5).m_82400_(radius);
    }

    public void showRadius(Level world) {
        GaiaArena.showRadius(world, this.center().m_122646_(), this.radius());
    }

    public static void showRadius(Level world, BlockPos center, double radius) {
        SparkleParticleData data = SparkleParticleData.sparkle((float)5.0f, (float)1.0f, (float)0.0f, (float)1.0f, (int)120);
        for (int i = 0; i < 360; i += 8) {
            float rad = (float)i * (float)Math.PI / 180.0f;
            double wx = (double)center.m_123341_() + 0.5 - Math.cos(rad) * radius;
            double wy = (double)center.m_123342_() + 0.5;
            double wz = (double)center.m_123343_() + 0.5 - Math.sin(rad) * radius;
            Proxy.INSTANCE.addParticleForceNear(world, (ParticleOptions)data, wx, wy, wz, 0.0, 0.0, 0.0);
        }
    }

    public List<Player> getPlayersAround(Level level) {
        return PlayerHelper.getRealPlayersIn((Level)level, (AABB)this.getArenaBB((double)this.radius() + 3.0));
    }

    public static void warnInvalidBlocks(Level world, Iterable<BlockPos> invalidPositions) {
        WispParticleData data = WispParticleData.wisp((float)0.5f, (float)1.0f, (float)0.2f, (float)0.2f, (float)8.0f, (boolean)false);
        for (BlockPos pos_ : invalidPositions) {
            world.m_7106_((ParticleOptions)data, (double)pos_.m_123341_() + 0.5, (double)pos_.m_123342_() + 0.5, (double)pos_.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public static void warnInvalidBlocksServer(ServerPlayer player, ServerLevel level, Iterable<BlockPos> invalidPositions) {
        WispParticleData data = WispParticleData.wisp((float)0.5f, (float)1.0f, (float)0.2f, (float)0.2f, (float)8.0f, (boolean)false);
        for (BlockPos pos_ : invalidPositions) {
            level.m_8624_(player, (ParticleOptions)data, false, (double)pos_.m_123341_() + 0.5, (double)pos_.m_123342_() + 0.5, (double)pos_.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static List<BlockPos> getInvalidPylons(Level world, BlockPos beaconPos, List<BlockPos> pylonLocations) {
        ArrayList<BlockPos> invalidPylonBlocks = new ArrayList<BlockPos>();
        for (BlockPos coords : pylonLocations) {
            BlockPos pos_ = beaconPos.m_121955_((Vec3i)coords);
            BlockState state = world.m_8055_(pos_);
            if (state.m_60713_(BotaniaBlocks.gaiaPylon)) continue;
            invalidPylonBlocks.add(pos_);
        }
        return invalidPylonBlocks;
    }
}

