/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.api.item;

import io.github.lounode.extrabotany.common.advancements.HasArmorSetTrigger;
import io.github.lounode.extrabotany.common.proxy.Proxy;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public interface ArmorSet {
    public ItemStack[] getArmorSetStacks();

    default public boolean hasArmorSet(Player player) {
        return this.hasArmorSetItem(player, EquipmentSlot.HEAD) && this.hasArmorSetItem(player, EquipmentSlot.CHEST) && this.hasArmorSetItem(player, EquipmentSlot.LEGS) && this.hasArmorSetItem(player, EquipmentSlot.FEET);
    }

    default public void triggerAdvancement(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            HasArmorSetTrigger.INSTANCE.trigger(serverPlayer);
        }
    }

    public boolean hasArmorSetItem(Player var1, EquipmentSlot var2);

    public MutableComponent getArmorSetName();

    private int getSetPiecesEquipped(Player player) {
        int pieces = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !this.hasArmorSetItem(player, slot)) continue;
            ++pieces;
        }
        return pieces;
    }

    private Component getArmorSetTitle(Player player) {
        MutableComponent end = this.getArmorSetName().m_130946_(" (" + this.getSetPiecesEquipped(player) + "/" + this.getArmorSetStacks().length + ")").m_130940_(ChatFormatting.GRAY);
        return Component.m_237115_((String)"botaniamisc.armorset").m_130946_(" ").m_7220_((Component)end);
    }

    default public void addInformation(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        ItemStack[] stacks;
        Player player = Proxy.INSTANCE.getClientPlayer();
        if (player == null) {
            return;
        }
        list.add(this.getArmorSetTitle(player));
        this.addArmorSetDescription(stack, list, this.hasArmorSet(player));
        for (ItemStack armor : stacks = this.getArmorSetStacks()) {
            MutableComponent cmp = Component.m_237113_((String)" - ").m_7220_(armor.m_41786_());
            EquipmentSlot slot = ((ArmorItem)armor.m_41720_()).m_40402_();
            cmp.m_130940_(this.hasArmorSetItem(player, slot) ? ChatFormatting.GREEN : ChatFormatting.GRAY);
            list.add((Component)cmp);
        }
    }

    public void addArmorSetDescription(ItemStack var1, List<Component> var2, boolean var3);
}

