/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.core;

import io.github.lounode.extrabotany.api.ExtraBotanyAPI;
import io.github.lounode.extrabotany.api.item.CoreOfTheVoidVariant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class ExtraBotanyModels {
    public static final ExtraBotanyModels INSTANCE = new ExtraBotanyModels();
    private final Map<ResourceLocation, Function<BakedModel, BakedModel>> afterBakeModifiers = new HashMap<ResourceLocation, Function<BakedModel, BakedModel>>();
    private final Map<ResourceLocation, Consumer<BakedModel>> modelConsumers = new HashMap<ResourceLocation, Consumer<BakedModel>>();
    public boolean registeredModels = false;

    private ExtraBotanyModels() {
        for (CoreOfTheVoidVariant variant : ExtraBotanyAPI.instance().getCOVVariants().values()) {
            variant.onModelInit(this.modelConsumers);
        }
    }

    public void onModelRegister(ResourceManager rm, Consumer<ResourceLocation> consumer) {
        this.modelConsumers.keySet().forEach(consumer);
        if (!this.registeredModels) {
            this.registeredModels = true;
        }
    }

    public void onModelBake(ModelBakery loader, Map<ResourceLocation, BakedModel> map) {
        if (!this.registeredModels) {
            ExtraBotanyAPI.LOGGER.error("Additional models failed to register! Aborting baking models to avoid early crashing.");
            return;
        }
        this.afterBakeModifiers.forEach((resourceLocation, afterBakeModifier) -> map.computeIfPresent((ResourceLocation)resourceLocation, (resourceLoc, bakedModel) -> (BakedModel)afterBakeModifier.apply(bakedModel)));
        this.modelConsumers.forEach((resourceLocation, bakedModelConsumer) -> bakedModelConsumer.accept((BakedModel)map.get(resourceLocation)));
    }

    public BakedModel modifyModelAfterbake(BakedModel bakedModel, ResourceLocation id) {
        this.modelConsumers.getOrDefault(id, model -> {}).accept(bakedModel);
        return (BakedModel)this.afterBakeModifiers.getOrDefault(id, Function.identity()).apply(bakedModel);
    }
}

