/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.gui;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lounode.extrabotany.client.gui.ColorfulBossBarOverlay;
import io.github.lounode.extrabotany.common.item.relic.CameraItem;
import io.github.lounode.extrabotany.common.item.relic.void_archives.VoidArchivesItem;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.Camera;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public final class HUD {
    public static HUD INSTANCE;
    private static final ResourceLocation manaBar;
    private final Minecraft minecraft;
    private final ColorfulBossBarOverlay bossOverlay;
    private float scopeScale;

    public HUD(Minecraft minecraft) {
        INSTANCE = this;
        this.minecraft = minecraft;
        this.bossOverlay = new ColorfulBossBarOverlay(minecraft);
    }

    public void onDrawScreenPost(GuiGraphics gui, float partialTicks) {
        PoseStack ms = gui.m_280168_();
        if (this.minecraft.f_91066_.f_92062_) {
            return;
        }
        ProfilerFiller profiler = this.minecraft.m_91307_();
        profiler.m_6180_("extrabotany-hud");
        float f = this.minecraft.m_91297_();
        this.scopeScale = Mth.m_14179_((float)(0.5f * f), (float)this.scopeScale, (float)1.125f);
        if (this.minecraft.f_91066_.m_92176_().m_90612_()) {
            if (this.shouldRenderCameraGUI()) {
                profiler.m_6180_("camera-hud");
                CameraItem.Hud.renderSpyglassOverlay(gui, this.scopeScale);
                profiler.m_7238_();
            } else {
                this.scopeScale = 0.5f;
            }
        }
        profiler.m_6180_("boss-bar");
        this.bossOverlay.render(gui);
        profiler.m_7238_();
        profiler.m_6180_("manaBar");
        this.renderManaBar(gui, partialTicks);
        profiler.m_7238_();
        profiler.m_7238_();
    }

    private void renderManaBar(GuiGraphics gui, float partialTicks) {
        LocalPlayer player = this.minecraft.f_91074_;
        if (player.m_5833_()) {
            return;
        }
        BigDecimal totalMana = BigDecimal.ZERO;
        BigDecimal totalMaxMana = BigDecimal.ZERO;
        boolean anyRequest = false;
        Inventory mainInv = player.m_150109_();
        Container accInv = BotaniaAPI.instance().getAccessoriesInventory((Player)player);
        int invSize = mainInv.m_6643_();
        int size = invSize + accInv.m_6643_();
        for (int i = 0; i < size; ++i) {
            boolean useAccessories = i >= invSize;
            Object inv = useAccessories ? accInv : mainInv;
            ItemStack stack = inv.m_8020_(i - (useAccessories ? invSize : 0));
            if (stack.m_41619_()) continue;
            anyRequest = anyRequest || stack.m_204117_(BotaniaTags.Items.MANA_USING_ITEMS);
        }
        List items = ManaItemHandler.instance().getManaItems((Player)player);
        List acc = ManaItemHandler.instance().getManaAccesories((Player)player);
        for (ItemStack stack : Iterables.concat((Iterable)items, (Iterable)acc)) {
            ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
            if (manaItem.isNoExport()) continue;
            totalMana = totalMana.add(BigDecimal.valueOf(manaItem.getMana()));
            totalMaxMana = totalMaxMana.add(BigDecimal.valueOf(manaItem.getMaxMana()));
        }
        if (anyRequest && !totalMaxMana.equals(BigDecimal.ZERO)) {
            HUD.renderManaInvBar(gui, totalMana.divide(totalMaxMana, 3, RoundingMode.HALF_UP).floatValue());
        }
    }

    private static void renderManaInvBar(GuiGraphics gui, float progress) {
        Minecraft mc = Minecraft.m_91087_();
        int width = 182;
        int x = mc.m_91268_().m_85445_() / 2 - width / 2;
        int y = mc.m_91268_().m_85446_() - BotaniaConfig.client().manaBarHeight();
        if ((width = (int)((double)width * (double)progress)) == 0) {
            width = 1;
        }
        int color = Mth.m_14169_((float)0.55f, (float)((float)Math.min(1.0, Math.sin((double)Util.m_137550_() / 200.0) * 0.5 + 1.0)), (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)(1.0f - (float)r / 255.0f));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderHelper.drawTexturedModalRect((GuiGraphics)gui, (ResourceLocation)manaBar, (int)x, (int)y, (int)0, (int)251, (int)width, (int)5);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private boolean shouldRenderCameraGUI() {
        ItemStack useItem = this.minecraft.f_91074_.m_21211_();
        if (useItem.m_41720_() instanceof CameraItem) {
            return true;
        }
        Item item = useItem.m_41720_();
        if (item instanceof VoidArchivesItem) {
            VoidArchivesItem item2 = (VoidArchivesItem)item;
            if (VoidArchivesItem.getVariant(useItem).getId().equals(Camera.INSTANCE.getId())) {
                return true;
            }
        }
        return false;
    }

    public static HUD getInstance() {
        return INSTANCE;
    }

    public ColorfulBossBarOverlay getBossOverlay() {
        return this.bossOverlay;
    }

    public static void onDisconnected() {
        HUD.getInstance().getBossOverlay().reset();
    }

    static {
        manaBar = ResourceLocation.m_135820_((String)"botania:textures/gui/mana_hud.png");
    }
}

