/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.integration.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import io.github.lounode.extrabotany.api.recipe.PedestalRecipe;
import io.github.lounode.extrabotany.client.integration.emi.EmiExtrabotanyPlugin;
import io.github.lounode.extrabotany.client.integration.emi.ExtrabotanyEmiRecipe;
import io.github.lounode.extrabotany.common.lib.ExtraBotanyTags;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import vazkii.botania.client.integration.emi.BlendTextureWidget;

public class PedestalEmiRecipe
extends ExtrabotanyEmiRecipe {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.prefixBotania("textures/gui/pure_daisy_overlay.png");
    private static final EmiIngredient PEDESTAL = EmiIngredient.of(ExtraBotanyTags.Blocks.PEDESTALS);
    protected EmiIngredient hammers;

    public PedestalEmiRecipe(PedestalRecipe recipe) {
        super(EmiExtrabotanyPlugin.PEDESTAL_SMASH, recipe);
        this.input = List.of(EmiIngredient.of((Ingredient)recipe.getInput()));
        this.output = List.of(EmiStack.of((ItemStack)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_)));
        this.hammers = EmiIngredient.of((Ingredient)recipe.getSmashTools());
    }

    public int getDisplayWidth() {
        return 142;
    }

    public int getDisplayHeight() {
        return 58;
    }

    public void addWidgets(WidgetHolder widgets) {
        PedestalEmiRecipe.addPedestalWidgets(widgets, (EmiRecipe)this, (EmiIngredient)this.input.get(0), PEDESTAL, (EmiStack)this.output.get(0), this.hammers);
    }

    public static void addPedestalWidgets(WidgetHolder widgets, EmiRecipe recipe, EmiIngredient input, EmiIngredient pedestal, EmiStack output, EmiIngredient hammers) {
        widgets.add((Widget)new BlendTextureWidget(TEXTURE, 40, -2, 64, 46, 0, 0));
        widgets.addSlot(input, 32, 13).drawBack(false);
        widgets.addSlot((EmiIngredient)output, 93, 13).drawBack(false).recipeContext(recipe);
        widgets.addSlot(pedestal, 62, 13).catalyst(true).drawBack(false);
        widgets.addSlot(hammers, 62, 43).catalyst(true).drawBack(false);
    }
}

