/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.integration.jei;

import io.github.lounode.extrabotany.api.recipe.ManaOutputRecipe;
import io.github.lounode.extrabotany.api.recipe.PedestalRecipe;
import io.github.lounode.extrabotany.client.integration.jei.PedestalRecipeCategory;
import io.github.lounode.extrabotany.client.integration.jei.StonesiaRecipeCategory;
import io.github.lounode.extrabotany.common.block.ExtraBotanyBlocks;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.brew.BrewUtil;
import io.github.lounode.extrabotany.common.brew.ExtraBotanyBrews;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.brew.ManaCocktailItem;
import io.github.lounode.extrabotany.common.item.relic.voidcore.CoreOfTheVoidItem;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.client.integration.jei.ManaPoolRecipeCategory;
import vazkii.botania.client.integration.jei.PureDaisyRecipeCategory;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.brew.BaseBrewItem;

@JeiPlugin
public class JEIExtraBotanyPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocationHelper.prefix("main");
    private static final Comparator<Recipe<?>> BY_ID = Comparator.comparing(Recipe::m_6423_);
    private static final Comparator<Recipe<?>> BY_GROUP = Comparator.comparing(Recipe::m_6076_);
    private static final Comparator<PedestalRecipe> BY_SMASH_TOOLS = (l, r) -> {
        Ingredient left = l.getSmashTools();
        Ingredient right = r.getSmashTools();
        return left.toString().compareTo(right.toString());
    };

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registry) {
        IIngredientSubtypeInterpreter interpreter = (stack, ctx) -> BaseBrewItem.getSubtype((ItemStack)stack);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ExtraBotanyItems.manaCocktail, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ExtraBotanyItems.infiniteWine, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ExtraBotanyItems.holyWaterGrenade, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ExtraBotanyItems.coreOfTheVoid, (stack, ctx) -> CoreOfTheVoidItem.getVariant(stack));
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        registry.addRecipes(PedestalRecipeCategory.TYPE, JEIExtraBotanyPlugin.sortRecipes(ExtraBotanyRecipeTypes.PEDESTAL_SMASH_TYPE, BY_SMASH_TOOLS.thenComparing(BY_GROUP).thenComparing(BY_ID)));
        registry.addRecipes(StonesiaRecipeCategory.TYPE, JEIExtraBotanyPlugin.sortRecipes(ExtraBotanyRecipeTypes.STONESIA_RECIPE_TYPE, Comparator.comparing(ManaOutputRecipe::getManaOutput).thenComparing(BY_GROUP).thenComparing(BY_ID)).stream().filter(recipe -> {
            StateIngredient input = recipe.getInput();
            return !input.getDisplayed().isEmpty();
        }).collect(Collectors.toList()));
        this.registerCocktailRecipes(registry);
        this.registerInfiniteWineRecipes(registry);
        this.registerHolyWaterGrenadeRecipes(registry);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new PedestalRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new StonesiaRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        for (Block pedestal : ExtraBotanyBlocks.ALL_PEDESTALS) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)pedestal), new RecipeType[]{PedestalRecipeCategory.TYPE});
        }
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ExtrabotanyFlowerBlocks.stonesia), new RecipeType[]{StonesiaRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ExtrabotanyFlowerBlocks.stonesiaFloating), new RecipeType[]{StonesiaRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ExtraBotanyItems.pureDaisyPendant), new RecipeType[]{PureDaisyRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ExtraBotanyItems.lensSmelt), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ExtraBotanyItems.lensMana), new RecipeType[]{ManaPoolRecipeCategory.TYPE});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager manager = jeiRuntime.getRecipeManager();
        ResourceLocation recipeId = ResourceLocationHelper.prefix("das_rheingold_change_bind");
        List toHide = manager.createRecipeLookup(RecipeTypes.CRAFTING).get().filter(r -> r.m_6423_().equals((Object)recipeId)).collect(Collectors.toList());
        if (!toHide.isEmpty()) {
            manager.hideRecipes(RecipeTypes.CRAFTING, toHide);
        }
    }

    private static <T extends Recipe<C>, C extends Container> List<T> sortRecipes(net.minecraft.world.item.crafting.RecipeType<T> type, Comparator<? super T> comparator) {
        Collection<T> recipes = ExtraBotanyRecipeTypes.getRecipes((Level)Minecraft.m_91087_().f_91073_, type).values();
        ArrayList<T> list = new ArrayList<T>(recipes);
        list.sort(comparator);
        return list;
    }

    private void registerCocktailRecipes(IRecipeRegistration registry) {
        ArrayList<ShapelessRecipe> recipes = new ArrayList<ShapelessRecipe>();
        for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
            if (brew == ExtraBotanyBrews.manaCocktail || brew == BotaniaBrews.fallbackBrew) continue;
            ItemStack cocktail = ManaCocktailItem.getDefaultCocktail();
            ItemStack flask = BotaniaItems.brewFlask.m_7968_();
            BrewUtil.setBrew(flask, brew);
            ResourceLocation id = ResourceLocationHelper.prefix("mana_cocktail_change_brew");
            NonNullList ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{cocktail}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{flask})});
            ItemStack result = ExtraBotanyItems.manaCocktail.m_7968_();
            BrewUtil.setBrew(result, brew);
            ShapelessRecipe compose = new ShapelessRecipe(id, "mana_cocktail_change_brew", CraftingBookCategory.MISC, result, ingredients);
            recipes.add(compose);
        }
        registry.addRecipes(RecipeTypes.CRAFTING, recipes);
    }

    private void registerInfiniteWineRecipes(IRecipeRegistration registry) {
        ArrayList<ShapelessRecipe> recipes = new ArrayList<ShapelessRecipe>();
        for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
            if (brew == BotaniaBrews.fallbackBrew) continue;
            ItemStack cocktail = ExtraBotanyItems.manaCocktail.m_7968_();
            BrewUtil.setBrew(cocktail, brew);
            if (brew == ExtraBotanyBrews.manaCocktail) {
                cocktail = ManaCocktailItem.getDefaultCocktail();
            }
            ItemStack medal = ExtraBotanyItems.heroMedal.m_7968_();
            ResourceLocation id = ResourceLocationHelper.prefix("infinite_wine");
            NonNullList ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{cocktail}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{medal})});
            ItemStack result = ExtraBotanyItems.infiniteWine.m_7968_();
            BrewUtil.setBrew(result, brew);
            ShapelessRecipe compose = new ShapelessRecipe(id, "infinite_wine", CraftingBookCategory.MISC, result, ingredients);
            recipes.add(compose);
        }
        registry.addRecipes(RecipeTypes.CRAFTING, recipes);
    }

    private void registerHolyWaterGrenadeRecipes(IRecipeRegistration registry) {
        ArrayList<ShapelessRecipe> recipes = new ArrayList<ShapelessRecipe>();
        for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
            if (brew == BotaniaBrews.fallbackBrew) continue;
            ItemStack cocktail = ExtraBotanyItems.manaCocktail.m_7968_();
            BrewUtil.setBrew(cocktail, brew);
            if (brew == ExtraBotanyBrews.manaCocktail) {
                cocktail = ManaCocktailItem.getDefaultCocktail();
            }
            ItemStack fruit = Items.f_42731_.m_7968_();
            ResourceLocation id = ResourceLocationHelper.prefix("holy_water_grenade");
            NonNullList ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{cocktail}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{fruit})});
            ItemStack result = ExtraBotanyItems.holyWaterGrenade.m_7968_();
            BrewUtil.setBrew(result, brew);
            ShapelessRecipe compose = new ShapelessRecipe(id, "holy_water_grenade", CraftingBookCategory.MISC, result, ingredients);
            recipes.add(compose);
        }
        registry.addRecipes(RecipeTypes.CRAFTING, recipes);
    }
}

