/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.block_entity;

import io.github.lounode.extrabotany.api.block.Charger;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.mana.BellowsBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.xplat.BotaniaConfig;

public abstract class ChargerBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements Charger {
    public int tickCount;

    public ChargerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public int m_6893_() {
                return 1;
            }
        };
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.m_7983_()) {
            ItemStack stack = player.m_21120_(hand);
            if (!this.isValidItem(stack)) {
                return InteractionResult.PASS;
            }
            ItemStack put = stack.m_41620_(1);
            this.setItem(put);
            return InteractionResult.SUCCESS;
        }
        ItemStack get = this.getItem().m_41777_();
        this.setItem(ItemStack.f_41583_);
        if (player.m_36356_(get)) {
            this.playSound();
        } else {
            Containers.m_18992_((Level)world, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)get);
        }
        return InteractionResult.SUCCESS;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ChargerBlockEntity self) {
        ManaPoolBlockEntity pool;
        if (self.tickCount % 10 == 0) {
            self.m_6596_();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)self);
        }
        if ((pool = self.getPool()) == null) {
            return;
        }
        BlockPos poolPos = pool.m_58899_();
        ManaItem mana = EXplatAbstractions.INSTANCE.findManaItem(self.getItem());
        if (mana == null || !mana.canReceiveManaFromPool((BlockEntity)pool) && !mana.canExportManaToPool((BlockEntity)pool)) {
            return;
        }
        boolean didSomething = false;
        List<BellowsBlockEntity> bellows = self.getBellows(level, poolPos, pool);
        int bellowCount = bellows.size();
        int transferRate = 1000 * (bellowCount + 1);
        if (pool.isOutputtingPower() && mana.canReceiveManaFromPool((BlockEntity)pool)) {
            int output = pool.getCurrentMana();
            output = Math.min(output, mana.getMaxMana() - mana.getMana());
            if ((output = Math.min(output, transferRate)) > 0) {
                didSomething = true;
                mana.addMana(output);
                pool.receiveMana(-output);
            }
        } else if (mana.canExportManaToPool((BlockEntity)pool)) {
            int input = mana.getMana();
            input = Math.min(input, pool.getMaxMana() - pool.getCurrentMana());
            if ((input = Math.min(input, transferRate)) > 0) {
                didSomething = true;
                mana.addMana(-input);
                pool.receiveMana(input);
            }
        }
        if (didSomething) {
            if (self.tickCount % 10 == 0 && BotaniaConfig.common().chargingAnimationEnabled()) {
                self.chargeParticles();
            }
            for (BellowsBlockEntity bellow : bellows) {
                bellow.setActive(true);
            }
        }
        ++self.tickCount;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ChargerBlockEntity self) {
        ++self.tickCount;
    }

    public void chargeParticles() {
        ManaPoolBlockEntity pool = this.getPool();
        if (pool == null) {
            return;
        }
        BlockPos poolPos = pool.m_58899_();
        this.f_58857_.m_7696_(poolPos, this.f_58857_.m_8055_(poolPos).m_60734_(), pool.isOutputtingPower() ? 1 : 2, ChargerBlockEntity.encodeRelativeItemPosition(poolPos, (float)this.f_58858_.m_123341_() + 0.5f, this.f_58858_.m_123342_(), (float)this.f_58858_.m_123343_() + 0.5f));
    }

    @Override
    public void setItem(ItemStack stack) {
        this.m_6836_(0, stack);
    }

    @Override
    public ItemStack getItem() {
        return this.m_8020_(0);
    }

    @Override
    public float getChargeProcess() {
        ManaItem mana = EXplatAbstractions.INSTANCE.findManaItem(this.getItem());
        if (mana != null) {
            return (float)((double)mana.getMana() / (double)mana.getMaxMana());
        }
        return -1.0f;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.isValidItem(stack);
    }

    private void playSound() {
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
    }

    @Nullable
    public abstract ManaPoolBlockEntity getPool();

    public List<BellowsBlockEntity> getBellows(Level level, BlockPos worldPosition, ManaPoolBlockEntity self) {
        ArrayList<BellowsBlockEntity> bellows = new ArrayList<BellowsBlockEntity>();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BellowsBlockEntity bellow;
            BlockEntity tile = level.m_7702_(worldPosition.m_121945_(dir));
            if (!(tile instanceof BellowsBlockEntity) || (bellow = (BellowsBlockEntity)tile).getLinkedTile() != self) continue;
            bellows.add(bellow);
        }
        return bellows;
    }

    private static int encodeRelativeItemPosition(BlockPos worldPosition, double x, double y, double z) {
        double relX = Mth.m_14008_((double)(x - (double)worldPosition.m_123341_()), (double)0.0, (double)1.0);
        double relY = Mth.m_14008_((double)(0.125 + 0.875 * (y - (double)worldPosition.m_123342_())), (double)0.125, (double)0.9);
        double relZ = Mth.m_14008_((double)(z - (double)worldPosition.m_123343_()), (double)0.0, (double)1.0);
        int compressedX = (int)Math.round(7.0 * relX);
        int compressedY = 4 - Mth.m_14163_((int)(14 - (int)(14.0 * relY)));
        int compressedZ = (int)Math.round(7.0 * relZ);
        return compressedX | compressedY << 3 | compressedZ << 5;
    }
}

