/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.functional;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;

public class EnchanterBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final String TAG_CONSUMED = "consumedMana";
    public static final int RANGE = 3;
    public static final int CONSUME_SPEED = 400;
    public static final int TRANSFORM_COST = 250000;
    private int consumedMana;

    public EnchanterBlockEntity(BlockEntityType<? extends EnchanterBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public EnchanterBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.ENCHANTER, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.consumedMana < this.getTransformCost()) {
            int manaCanConsume = Math.min(this.getConsumeSpeed(), this.getMana());
            if (manaCanConsume > 0) {
                this.addMana(-manaCanConsume);
                this.setConsumedMana(this.getConsumedMana() + manaCanConsume);
                this.sync();
            }
            return;
        }
        if (this.ticksExisted % 20 != 0) {
            return;
        }
        BlockPos transformPos = this.getRandomPos();
        if (transformPos == null) {
            return;
        }
        this.m_58904_().m_46597_(transformPos, BotaniaBlocks.enchantedSoil.m_49966_());
        this.setConsumedMana(0);
        this.sync();
    }

    @Nullable
    public BlockPos getRandomPos() {
        Object pos_2;
        HashMap<BlockPos, Float> coordsMap = new HashMap<BlockPos, Float>();
        Random rng = new Random();
        BlockPos pos = this.getEffectivePos();
        for (Object pos_2 : BlockPos.m_121940_((BlockPos)pos.m_7918_(-3, -3, -3), (BlockPos)pos.m_7918_(3, 3, 3))) {
            BlockState state = this.m_58904_().m_8055_((BlockPos)pos_2);
            BlockState above = this.m_58904_().m_8055_(pos_2.m_7494_());
            if (!state.m_60713_(Blocks.f_50440_) || !above.m_60795_()) continue;
            coordsMap.put(pos_2.m_7949_(), Float.valueOf(2.0f * rng.nextFloat()));
        }
        if (coordsMap.isEmpty()) {
            return null;
        }
        float maxDistance = 0.0f;
        pos_2 = coordsMap.values().iterator();
        while (pos_2.hasNext()) {
            float distance = ((Float)pos_2.next()).floatValue();
            maxDistance = Math.max(maxDistance, distance);
        }
        float finalMaxDistance = maxDistance;
        coordsMap.values().removeIf(dist -> dist.floatValue() < finalMaxDistance - 1.0f);
        ArrayList coords = new ArrayList(coordsMap.keySet());
        BlockPos breakCoords = (BlockPos)coords.get(this.f_58857_.m_213780_().m_188503_(coords.size()));
        return breakCoords;
    }

    public int getTransformCost() {
        return ExtraBotanyConfig.common().enchanterTransformCost();
    }

    public int getConsumeSpeed() {
        return ExtraBotanyConfig.common().enchanterConsumeSpeed();
    }

    public int getMaxMana() {
        return this.getConsumeSpeed() * 4;
    }

    public int getColor() {
        return 4915330;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)3);
    }

    public int getConsumedMana() {
        return this.consumedMana;
    }

    public void setConsumedMana(int consumedMana) {
        this.consumedMana = consumedMana;
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_CONSUMED, this.getConsumedMana());
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.setConsumedMana(cmp.m_128451_(TAG_CONSUMED));
    }

    public static class WandHUD
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<EnchanterBlockEntity> {
        public WandHUD(EnchanterBlockEntity flower) {
            super((BindableSpecialFlowerBlockEntity)flower);
        }

        public void renderHUD(GuiGraphics gui, Minecraft mc, int minLeft, int minRight, int minDown) {
            String name = I18n.m_118938_((String)((EnchanterBlockEntity)this.flower).m_58900_().m_60734_().m_7705_(), (Object[])new Object[0]);
            int color = ((EnchanterBlockEntity)this.flower).getColor();
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            int left = (Math.max(102, mc.f_91062_.m_92895_(name)) + 4) / 2;
            int right = left + 20;
            left = Math.max(left, minLeft);
            right = Math.max(right, minRight);
            RenderHelper.renderHUDBox((GuiGraphics)gui, (int)(centerX - left), (int)(centerY + 8), (int)(centerX + right), (int)(centerY + Math.max(30, minDown + 52)));
            BotaniaAPIClient.instance().drawComplexManaHUD(gui, color, ((EnchanterBlockEntity)this.flower).getConsumedMana(), ((EnchanterBlockEntity)this.flower).getTransformCost(), name, ((EnchanterBlockEntity)this.flower).getHudIcon(), ((EnchanterBlockEntity)this.flower).isValidBinding());
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            int arrowU = 0;
            int arrowV = 38;
            RenderHelper.drawTexturedModalRect((GuiGraphics)gui, (ResourceLocation)HUDHandler.manaBar, (int)(centerX - 11), (int)(centerY + 34), (int)arrowU, (int)arrowV, (int)22, (int)15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack grass = new ItemStack((ItemLike)Items.f_42276_);
            ItemStack enchanted = new ItemStack((ItemLike)BotaniaBlocks.enchantedSoil);
            gui.m_280480_(grass, centerX - 31, centerY + 34);
            gui.m_280480_(enchanted, centerX + 15, centerY + 34);
        }
    }
}

