/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.functional;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtend;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtendBuilder;
import io.github.lounode.extrabotany.api.gaia.BlockTagPredicate;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.xplat.XplatAbstractions;

public class ManalinkBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    public static final String[][] PATTERN = new String[][]{{"QQQQQ", "QLOLQ", "QODOQ", "QLOLQ", "QQQQQ"}};
    public static final String[][] PATCHOULI_PATTERN = new String[][]{{"AAAAA", "AAAAA", "AA0AA", "AAAAA", "AAAAA"}, {"QQQQQ", "QLOLQ", "QODOQ", "QLOLQ", "QQQQQ"}};
    public static final BlockPatternExtend PATTERN_BUILTIN = new BlockPatternExtend(BlockPatternExtendBuilder.start().aisle(PATTERN[0]).where('D', BlockInWorld.m_61169_((Predicate)BlockTagPredicate.forTag((TagKey<Block>)BlockTags.f_144274_))).where('Q', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50333_))).where('L', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50060_))).where('O', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50080_))).createPattern());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_LINK_POS = "linkPos";
    public static final int TRANSFER_SPEED = 400;
    @Nullable
    private GlobalPos linkPos = null;

    public ManalinkBlockEntity(BlockEntityType<? extends ManalinkBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ManalinkBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.MANALINK, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.getMana() <= 0) {
            return;
        }
        GlobalPos pos = this.linkPos;
        if (pos == null) {
            return;
        }
        ManaPool pool = this.getManaPool(this.m_58904_().m_7654_(), pos);
        if (pool == null) {
            return;
        }
        if (this.findBoundTile() != null && this.findBoundTile() == pool) {
            return;
        }
        if (PATTERN_BUILTIN.findFlat((LevelReader)this.m_58904_(), this.m_58899_().m_7495_()) == null) {
            return;
        }
        int transferMana = Math.min(this.getTransferSpeed(), this.getMana());
        int poolCanReceiveMana = pool.getMaxMana() - pool.getCurrentMana();
        if ((transferMana = Math.min(transferMana, poolCanReceiveMana)) > 0) {
            this.addMana(-transferMana);
            pool.receiveMana(transferMana);
            this.sync();
        }
    }

    @Nullable
    private ManaPool getManaPool(@Nullable MinecraftServer server, GlobalPos pos) {
        ManaReceiver receiver;
        if (server == null) {
            return null;
        }
        ResourceKey type = pos.m_122640_();
        ServerLevel world = server.m_129880_(type);
        if (world != null && (receiver = XplatAbstractions.INSTANCE.findManaReceiver((Level)world, pos.m_122646_(), null)) instanceof ManaPool) {
            ManaPool pool = (ManaPool)receiver;
            return pool;
        }
        return null;
    }

    public int getTransferSpeed() {
        return ExtraBotanyConfig.common().manalinkTransferSpeed();
    }

    public int getMaxMana() {
        return this.getTransferSpeed() * 2;
    }

    public int getColor() {
        return 65535;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return null;
    }

    public Optional<GlobalPos> getLinkPos() {
        return Optional.ofNullable(this.linkPos);
    }

    public void setLinkPos(GlobalPos pos) {
        this.linkPos = pos;
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        if (this.linkPos != null) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.linkPos).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> cmp.m_128365_(TAG_LINK_POS, tag));
        }
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)cmp.m_128423_(TAG_LINK_POS)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setLinkPos);
    }

    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        return false;
    }

    public static class WandHUD
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<ManalinkBlockEntity> {
        public WandHUD(ManalinkBlockEntity flower) {
            super((BindableSpecialFlowerBlockEntity)flower);
        }

        public void renderHUD(GuiGraphics gui, Minecraft mc, int minLeft, int minRight, int minDown) {
            float scale = 0.8f;
            GlobalPos pos = ((ManalinkBlockEntity)this.flower).linkPos;
            if (pos == null) {
                super.renderHUD(gui, mc, minLeft, minRight, minDown);
                return;
            }
            MutableComponent levelComponent = Component.m_237110_((String)"message.extrabotany.actionbar.bind_to_pos", (Object[])new Object[]{String.valueOf(pos.m_122640_().m_135782_()) + String.format(" %d, %d, %d", pos.m_122646_().m_123341_(), pos.m_122646_().m_123342_(), pos.m_122646_().m_123343_())});
            int halfWidth = (int)((float)(mc.f_91062_.m_92852_((FormattedText)levelComponent) + 24) / 2.0f * scale);
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            super.renderHUD(gui, mc, halfWidth + 2, halfWidth + 2, 48);
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_85841_(scale, scale, 1.0f);
            gui.m_280430_(mc.f_91062_, (Component)levelComponent, (int)((float)(centerX - halfWidth + 12) / scale), (int)((float)(centerY + 34) / scale), ChatFormatting.GREEN.m_126665_().intValue());
            gui.m_280168_().m_85849_();
        }
    }
}

