/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.functional;

import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.brew.ExtraBotanyMobEffects;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;

public class NecrofleurBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 7;
    private static final float DAMAGE = 10.0f;
    private static final int RANGE_MINI = 3;
    private static final float DAMAGE_MINI = 6.0f;
    public static final int MAX_MANA = 200;
    public static final int COOLDOWN = 20;
    public static final int DAMAGE_COST = 200;

    public NecrofleurBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.NECROFLEUR, pos, state);
    }

    public NecrofleurBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.ticksExisted % 20 != 0) {
            return;
        }
        if (this.getMana() < this.getDamageCost()) {
            return;
        }
        List entities = this.m_58904_().m_45976_(LivingEntity.class, new AABB(this.getEffectivePos()).m_82400_((double)this.getRange()));
        for (LivingEntity entity : entities) {
            if (this.getMana() < this.getDamageCost()) break;
            if (!(entity.m_21223_() <= entity.m_21233_() * 0.5f)) continue;
            entity.m_6469_(entity.m_269291_().m_269104_((Entity)entity, (Entity)entity), this.getDamage());
            entity.m_7292_(new MobEffectInstance(ExtraBotanyMobEffects.HEAL_REVERSE, 300));
            this.addMana(-this.getDamageCost());
            this.sync();
            break;
        }
    }

    public int getDamageCost() {
        return 200;
    }

    public int getRange() {
        return 7;
    }

    public float getDamage() {
        return 10.0f;
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().necrofleurMaxMana();
    }

    public int getColor() {
        return 10506328;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)this.getRange());
    }

    public static class Mini
    extends NecrofleurBlockEntity {
        public Mini(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        public Mini(BlockPos pos, BlockState state) {
            super(ExtrabotanyFlowerBlocks.NECROFLEUR_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return 3;
        }

        @Override
        public float getDamage() {
            return 6.0f;
        }
    }
}

