/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import io.github.lounode.extrabotany.api.block.PassiveFlower;
import io.github.lounode.extrabotany.api.level.Wind;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.lib.ExtraBotanyTags;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.common.util.SoundEventUtil;
import io.github.lounode.extrabotany.mixin.accessor.DaffomillBlockEntityAccessor;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.flower.functional.DaffomillBlockEntity;
import vazkii.botania.common.helper.PlayerHelper;

public class BellflowerBlockEntity
extends GeneratingFlowerBlockEntity
implements PassiveFlower {
    public static final String TAG_DYING = "dying";
    public static int MAX_MANA = 300;
    public static final double GENERATE_MODIFY = 1.0;
    private static final int SPACE_REQUIRE = 2;
    private static final double WIND_LEVEL_MODIFY = 0.5;
    private int passiveDecayTicks;
    private boolean dying;
    private int dyingTicks;

    public BellflowerBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.BELLFLOWER, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.isDying()) {
            this.sync();
            this.dyingAnime();
            ++this.dyingTicks;
            return;
        }
        if (this.m_58904_().m_5776_()) {
            return;
        }
        this.checkToDecay((SpecialFlowerBlockEntity)this);
        if (!this.m_58904_().m_45527_(this.getEffectivePos())) {
            return;
        }
        if (this.ticksExisted % 5 != 0) {
            return;
        }
        if (this.ticksExisted % 100 == 0 && this.m_58904_().m_213780_().m_188503_(2) == 0) {
            this.m_58904_().m_5594_(null, this.getEffectivePos(), ExtraBotanySounds.BELL_FLOWER_RING, SoundSource.BLOCKS, 0.5f, SoundEventUtil.randomPitch(this.m_58904_()));
        }
        this.addMana(Math.max(0, this.getGenerateMana()));
        this.sync();
    }

    private void dyingAnime() {
        if (this.dyingTicks < 60) {
            if (this.dyingTicks % 10 == 0) {
                for (int i = 0; i < 3; ++i) {
                    double offsetX = this.m_58904_().m_213780_().m_188500_() * 2.0 - 1.0;
                    double offsetY = this.m_58904_().m_213780_().m_188500_() * 0.5;
                    double offsetZ = this.m_58904_().m_213780_().m_188500_() * 2.0 - 1.0;
                    Vec3 particlePos = Vec3.m_82512_((Vec3i)this.m_58899_()).m_82520_(offsetX, offsetY, offsetZ);
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.05, 0.0);
                }
            }
            return;
        }
        if (this.m_58904_().m_5776_()) {
            return;
        }
        this.m_58904_().m_46961_(this.m_58899_(), false);
        if (Blocks.f_50036_.m_49966_().m_60710_((LevelReader)this.m_58904_(), this.m_58899_())) {
            this.m_58904_().m_46597_(this.m_58899_(), Blocks.f_50036_.m_49966_());
        }
        List players = PlayerHelper.getRealPlayersIn((Level)this.m_58904_(), (AABB)new AABB(this.m_58899_()).m_82400_(16.0));
        for (Player player : players) {
            if (PlayerHelper.hasAdvancement((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix("main/a_baldrupt"))) continue;
            PlayerHelper.grantCriterion((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix("main/a_baldrupt"), (String)"code_triggered");
        }
    }

    public int getGenerateMana() {
        double windLevel = Wind.instance().getWindLevel(this.m_58904_(), new Vec3((double)this.getEffectivePos().m_123341_(), (double)this.getEffectivePos().m_123342_(), (double)this.getEffectivePos().m_123343_()));
        double negativeBlockModify = this.countNegativeBlocks();
        return (int)((windLevel - negativeBlockModify) * this.getWindLevelModify() * this.getGenerateModify());
    }

    public int countNegativeBlocks() {
        int negative = 0;
        BlockPos pos = this.getEffectivePos();
        for (BlockPos pos_ : BlockPos.m_121940_((BlockPos)pos.m_7918_(-this.getSpaceRequire(), 0, -this.getSpaceRequire()), (BlockPos)pos.m_7918_(this.getSpaceRequire(), this.getSpaceRequire(), this.getSpaceRequire()))) {
            if (pos_.equals((Object)pos)) continue;
            BlockState state = this.m_58904_().m_8055_(pos_);
            if (state.m_60713_(ExtrabotanyFlowerBlocks.bellflower) || state.m_60713_(ExtrabotanyFlowerBlocks.bellflowerFloating)) {
                ++negative;
            }
            if (!state.m_60795_() && !state.m_204336_(ExtraBotanyTags.Blocks.BELLFLOWER_IGNORE)) {
                ++negative;
            }
            if (!state.m_60713_(BotaniaFlowerBlocks.daffomill) && !state.m_60713_(BotaniaFlowerBlocks.daffomillFloating)) continue;
            this.checkBeBlew(pos_);
        }
        return negative;
    }

    public void checkBeBlew(BlockPos daffomillPos) {
        Vec3 posVec;
        BlockEntity tile = this.m_58904_().m_7702_(daffomillPos);
        if (!(tile instanceof DaffomillBlockEntity)) {
            return;
        }
        DaffomillBlockEntity daffomill = (DaffomillBlockEntity)tile;
        if (daffomill.redstoneSignal > 0) {
            return;
        }
        if (((DaffomillBlockEntityAccessor)daffomill).getWindTicks() <= 0) {
            return;
        }
        AABB aabb = ((DaffomillBlockEntityAccessor)daffomill).extrabotany_aabbForOrientation();
        if (!aabb.m_82390_(posVec = Vec3.m_82512_((Vec3i)this.m_58899_()))) {
            return;
        }
        this.dying = true;
    }

    public int getSpaceRequire() {
        return 2;
    }

    public double getWindLevelModify() {
        return 0.5;
    }

    public double getGenerateModify() {
        return ExtraBotanyConfig.common().bellflowerGenerateModify();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().bellflowerMaxMana();
    }

    public int getColor() {
        return 0xFFFF99;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return null;
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.setPassiveDecayTicks(cmp.m_128451_("passiveDecayTicks"));
        this.dying = cmp.m_128471_(TAG_DYING);
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_("passiveDecayTicks", this.getPassiveDecayTicks());
        cmp.m_128379_(TAG_DYING, this.dying);
    }

    @Override
    public int getPassiveDecayTicks() {
        return this.passiveDecayTicks;
    }

    @Override
    public void setPassiveDecayTicks(int ticks) {
        this.passiveDecayTicks = ticks;
    }

    public boolean isDying() {
        return this.dying;
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<BellflowerBlockEntity> {
        public WandHud(BellflowerBlockEntity flower) {
            super((BindableSpecialFlowerBlockEntity)flower);
        }

        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            double windLevel = Wind.instance().getWindLevel(((BellflowerBlockEntity)this.flower).m_58904_(), new Vec3((double)((BellflowerBlockEntity)this.flower).getEffectivePos().m_123341_(), (double)((BellflowerBlockEntity)this.flower).getEffectivePos().m_123342_(), (double)((BellflowerBlockEntity)this.flower).getEffectivePos().m_123343_()));
            if (((BellflowerBlockEntity)this.flower).isDying()) {
                windLevel = 999.0;
            }
            MutableComponent component = Component.m_237110_((String)"message.extrabotany.chat.wind_level", (Object[])new Object[]{String.format("%.2f", windLevel)});
            int halfWidth = (mc.f_91062_.m_92852_((FormattedText)component) + 24) / 2;
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            super.renderHUD(gui, mc, halfWidth + 2, halfWidth + 2, 48);
            gui.m_280430_(mc.f_91062_, (Component)component, centerX - halfWidth + 12, centerY + 34, !((BellflowerBlockEntity)this.flower).isDying() ? 0xFFFFFF : ChatFormatting.DARK_RED.m_126665_());
        }
    }
}

