/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import io.github.lounode.extrabotany.api.recipe.OmnivioletRecipe;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;

public class OmnivioletBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_BURN_TIME = "burnTime";
    public static final int MAX_MANA = 1500;
    private static final int RANGE = 2;
    private static final int START_BURN_EVENT = 0;
    private int burnTime = 0;

    public OmnivioletBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.OMNIVIOLET, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.getBurnTime() > 0) {
            this.burnTick();
            this.setBurnTime(this.getBurnTime() - 1);
            return;
        }
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.getMana() >= this.getMaxMana()) {
            return;
        }
        for (ItemEntity item : this.m_58904_().m_45976_(ItemEntity.class, new AABB(this.getEffectivePos().m_7918_(-2, -2, -2), this.getEffectivePos().m_7918_(3, 3, 3)))) {
            ItemStack stack;
            int addTime;
            if (!DelayHelper.canInteractWith((SpecialFlowerBlockEntity)this, (ItemEntity)item) || (addTime = this.getFeedBurnTime(stack = item.m_32055_())) <= 0 || stack.m_41613_() <= 0) continue;
            this.setBurnTime(addTime);
            EntityHelper.shrinkItem((ItemEntity)item);
            this.m_58904_().m_5594_(null, this.getEffectivePos(), SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.m_58904_().m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, item.m_19879_());
            this.m_58904_().m_142346_(null, GameEvent.f_223702_, this.m_58899_());
            this.sync();
            return;
        }
    }

    public void burnTick() {
        if (this.m_58904_().m_5776_()) {
            if (this.m_58904_().f_46441_.m_188503_(10) == 0) {
                this.emitParticle((ParticleOptions)ParticleTypes.f_123744_, 0.4 + Math.random() * 0.2, 0.7, 0.4 + Math.random() * 0.2, 0.0, 0.0, 0.0);
            }
        } else {
            float power = this.getEnchantPower();
            float buff = 1.0f + power * 0.05f;
            this.addMana((int)(8.0f * Math.min(7.0f, buff)));
            this.sync();
        }
    }

    public boolean m_7531_(int event, int param) {
        if (event == 0) {
            Entity e = this.m_58904_().m_6815_(param);
            if (e != null) {
                e.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, e.m_20185_(), e.m_20186_() + 0.1, e.m_20189_(), 0.0, 0.0, 0.0);
                e.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, e.m_20185_(), e.m_20186_(), e.m_20189_(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        return super.m_7531_(event, param);
    }

    public float getEnchantPower() {
        return EXplatAbstractions.INSTANCE.getEnchantPowerBonus((ServerLevel)this.m_58904_(), this.getEffectivePos());
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().omnivioletMaxMana();
    }

    public int getColor() {
        return 0xEE82EE;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)2);
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_BURN_TIME, this.getBurnTime());
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.setBurnTime(cmp.m_128451_(TAG_BURN_TIME));
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getFeedBurnTime(ItemStack stack) {
        for (Recipe recipe : ExtraBotanyRecipeTypes.getRecipes(this.m_58904_(), ExtraBotanyRecipeTypes.OMNIVIOLET_RECIPE_TYPE).values()) {
            OmnivioletRecipe recipe2;
            if (!(recipe instanceof OmnivioletRecipe) || !(recipe2 = (OmnivioletRecipe)recipe).getInput().test(stack)) continue;
            return recipe2.getBurnTime();
        }
        return 0;
    }
}

