/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import io.github.lounode.extrabotany.api.block.PassiveFlower;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;

public class SunshineLilyBlockEntity
extends GeneratingFlowerBlockEntity
implements PassiveFlower {
    public static final int MAX_MANA = 200;
    public static final int COOLDOWN = 4;
    public static final int MANA_PER_GENERATE = 2;
    private int passiveDecayTicks;

    public SunshineLilyBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.SUNSHINE_LILY, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        this.checkToDecay((SpecialFlowerBlockEntity)this);
        if (this.ticksExisted % 4 != 0) {
            return;
        }
        if (!this.m_58904_().m_46461_()) {
            return;
        }
        if (this.getMana() >= this.getMaxMana()) {
            return;
        }
        this.addMana(this.getGenerateMana());
        this.sync();
    }

    public int getGenerateMana() {
        return ExtraBotanyConfig.common().sunshineLilyProduceMana();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().sunshineLilyMaxMana();
    }

    public int getColor() {
        return 16753920;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return null;
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.setPassiveDecayTicks(cmp.m_128451_("passiveDecayTicks"));
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_("passiveDecayTicks", this.getPassiveDecayTicks());
    }

    @Override
    public int getPassiveDecayTicks() {
        return this.passiveDecayTicks;
    }

    @Override
    public void setPassiveDecayTicks(int ticks) {
        this.passiveDecayTicks = ticks;
    }
}

