/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.brew;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.helper.ItemNBTHelper;

public class BrewUtil {
    public static final Brew EMPTY = BotaniaBrews.fallbackBrew;
    public static final String TAG_BREW_KEY = "brewKey";

    public static Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_BREW_KEY, (String)"");
        Registry registry = BotaniaAPI.instance().getBrewRegistry();
        if (registry == null) {
            return BotaniaBrews.fallbackBrew;
        }
        ResourceLocation location = ResourceLocation.m_135820_((String)key);
        if (location == null) {
            return BotaniaBrews.fallbackBrew;
        }
        Brew brew = (Brew)registry.m_7745_(location);
        return brew != null ? brew : BotaniaBrews.fallbackBrew;
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ResourceLocation id = Objects.requireNonNull(BotaniaAPI.instance().getBrewRegistry()).m_7981_((Object)brew);
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_BREW_KEY, (String)id.toString());
    }

    public static boolean hasInstantEffects(Brew brew) {
        if (!BrewUtil.getPotionEffects(brew).isEmpty()) {
            for (MobEffectInstance mobeffectinstance : BrewUtil.getPotionEffects(brew)) {
                if (!mobeffectinstance.m_19544_().m_8093_()) continue;
                return true;
            }
        }
        return false;
    }

    public static List<MobEffectInstance> getPotionEffects(Brew brew) {
        if (!brew.getPotionEffects(new ItemStack((ItemLike)Items.f_41852_)).isEmpty()) {
            return brew.getPotionEffects(new ItemStack((ItemLike)Items.f_41852_));
        }
        return new ArrayList<MobEffectInstance>();
    }

    public static int getColor(Brew brew) {
        return brew.getColor(new ItemStack((ItemLike)Items.f_41852_));
    }

    public static void addPotionTooltip(Brew brew, List<Component> lores, float durationFactor, int amplifierAddition) {
        List<MobEffectInstance> list = BrewUtil.getPotionEffects(brew);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance effectinstance : list) {
                MutableComponent iformattabletextcomponent = Component.m_237115_((String)effectinstance.m_19576_());
                MobEffect effect = effectinstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectinstance.m_19564_() + amplifierAddition, attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.m_19564_() + amplifierAddition > 0) {
                    iformattabletextcomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, Component.m_237115_((String)("potion.potency." + (effectinstance.m_19564_() + amplifierAddition)))});
                }
                if (effectinstance.m_19557_() > 20) {
                    iformattabletextcomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{iformattabletextcomponent, MobEffectUtil.m_267641_((MobEffectInstance)effectinstance, (float)durationFactor)});
                }
                lores.add((Component)iformattabletextcomponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add((Component)Component.m_237119_());
            lores.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    lores.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

