/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.lounode.extrabotany.api.recipe.EdelweissRecipe;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class EdelweissRecipes
implements EdelweissRecipe {
    private final ResourceLocation id;
    private final EntityTypePredicate input;
    private final int outputMana;

    public EdelweissRecipes(ResourceLocation id, EntityTypePredicate input, int outputMana) {
        this.id = id;
        this.input = input;
        this.outputMana = outputMana;
    }

    @Override
    public EntityTypePredicate getInput() {
        return this.input;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return ExtraBotanyRecipeTypes.EDELWEISS_SERIALIZER;
    }

    @Override
    public RecipeType<? extends EdelweissRecipe> m_6671_() {
        return ExtraBotanyRecipeTypes.EDELWEISS_RECIPE_TYPE;
    }

    @Override
    public int getManaOutput() {
        return this.outputMana;
    }

    public static class Serializer
    implements RecipeSerializer<EdelweissRecipes> {
        public EdelweissRecipes fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            EntityTypePredicate input = EntityTypePredicate.m_37643_((JsonElement)json.getAsJsonPrimitive("input"));
            int outputMana = GsonHelper.m_13927_((JsonObject)json, (String)"outputMana");
            return new EdelweissRecipes(recipeId, input, outputMana);
        }

        public EdelweissRecipes fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            EntityTypePredicate input = EntityTypePredicate.m_37643_((JsonElement)new JsonPrimitive(buffer.m_130277_()));
            int outputMana = buffer.readInt();
            return new EdelweissRecipes(recipeId, input, outputMana);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull EdelweissRecipes recipe) {
            buffer.m_130070_(recipe.getInput().m_5908_().getAsString());
            buffer.writeInt(recipe.getManaOutput());
        }
    }
}

