/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.crafting.recipe;

import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.brew.BrewUtil;
import io.github.lounode.extrabotany.common.brew.ExtraBotanyBrews;
import io.github.lounode.extrabotany.common.crafting.recipe.CopyBrewRecipe;
import io.github.lounode.extrabotany.common.item.brew.ManaCocktailItem;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.item.BotaniaItems;

public final class CopyBrewFormFlaskRecipe
extends CopyBrewRecipe {
    public static final RecipeSerializer<CopyBrewFormFlaskRecipe> SERIALIZER = new Serializer();

    public CopyBrewFormFlaskRecipe(ShapelessRecipe compose) {
        super(compose);
    }

    @Override
    public Item getBrewSource() {
        return BotaniaItems.brewFlask;
    }

    @Override
    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack result = this.m_8043_(registries).m_41777_();
        ItemStack brewSource = ItemStack.f_41583_;
        ItemStack input = ItemStack.f_41583_;
        ArrayList<ItemStack> _inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack _input = inv.m_8020_(i);
            if (_input.m_41619_()) continue;
            if (_input.m_150930_(this.getBrewSource())) {
                brewSource = _input;
            } else {
                input = _input;
            }
            _inputs.add(_input);
        }
        if (_inputs.size() != 2 || brewSource.m_41619_() || input.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Item item = input.m_41720_();
        if (!(item instanceof ManaCocktailItem)) {
            return ItemStack.f_41583_;
        }
        ManaCocktailItem cocktail = (ManaCocktailItem)item;
        if (cocktail.getBrew(input) != ExtraBotanyBrews.manaCocktail || cocktail.getSwigsLeft(input) != 1) {
            return ItemStack.f_41583_;
        }
        BrewUtil.setBrew(result, BrewUtil.getBrew(brewSource));
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            Item item = container.m_8020_(i).m_41720_();
            if (item.m_41470_()) {
                nonnulllist.set(i, (Object)new ItemStack((ItemLike)item.m_41469_()));
                continue;
            }
            if (item != BotaniaItems.brewFlask) continue;
            nonnulllist.set(i, (Object)BotaniaItems.flask.m_7968_());
        }
        return nonnulllist;
    }

    private static class Serializer
    implements RecipeSerializer<CopyBrewFormFlaskRecipe> {
        private Serializer() {
        }

        public CopyBrewFormFlaskRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            return new CopyBrewFormFlaskRecipe((ShapelessRecipe)f_44077_.m_6729_(recipeId, json));
        }

        public CopyBrewFormFlaskRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            return new CopyBrewFormFlaskRecipe((ShapelessRecipe)f_44077_.m_8005_(recipeId, buffer));
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull CopyBrewFormFlaskRecipe recipe) {
            f_44077_.m_6178_(buffer, (Recipe)recipe);
        }
    }
}

