/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.crafting.recipe;

import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.UUID;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.helper.ItemNBTHelper;

public final class DasRheingoldChangeSoulBoundRecipe
extends CustomRecipe {
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";
    public static final NoOpRecipeSerializer<DasRheingoldChangeSoulBoundRecipe> SERIALIZER = new NoOpRecipeSerializer(DasRheingoldChangeSoulBoundRecipe::new);

    public DasRheingoldChangeSoulBoundRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        boolean findRheinGold = false;
        boolean findRelic = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(ExtraBotanyItems.dasRheingold)) {
                if (findRheinGold) {
                    return false;
                }
                findRheinGold = true;
                continue;
            }
            if (EXplatAbstractions.INSTANCE.findRelic(stack) == null) continue;
            if (findRelic) {
                return false;
            }
            findRelic = true;
        }
        return findRheinGold && findRelic;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack rheingold = ItemStack.f_41583_;
        ItemStack relic = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == ExtraBotanyItems.dasRheingold) {
                rheingold = stack;
                continue;
            }
            relic = stack;
        }
        if (rheingold.m_41619_() || relic.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (EXplatAbstractions.INSTANCE.findRelic(relic) == null) {
            return ItemStack.f_41583_;
        }
        ItemStack relicOutput = relic.m_41777_();
        UUID rheingoldUUID = DasRheingoldChangeSoulBoundRecipe.getSoulbindUUID(rheingold);
        if (rheingoldUUID == null) {
            ItemNBTHelper.removeEntry((ItemStack)relicOutput, (String)TAG_SOULBIND_UUID);
        } else {
            DasRheingoldChangeSoulBoundRecipe.bindToUUID(relicOutput, rheingoldUUID);
        }
        return relicOutput;
    }

    public static void bindToUUID(ItemStack stack, UUID uuid) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)uuid.toString());
    }

    @Nullable
    public static UUID getSoulbindUUID(ItemStack stack) {
        if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry((ItemStack)stack, (String)TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    public boolean m_8004_(int width, int height) {
        return width > 1 || height > 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

