/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia.behavior;

import com.google.common.collect.ImmutableMap;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;

public class GaiaCleanPlayerUnstableEffects<E extends Gaia>
extends Behavior<E> {
    public GaiaCleanPlayerUnstableEffects() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26367_, (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        return true;
    }

    protected void tick(ServerLevel level, E gaia, long gameTime) {
        List<Player> players = this.getPlayers((Gaia)((Object)gaia));
        for (Player player : players) {
            this.clearUnstablePotions(player);
        }
    }

    protected void clearUnstablePotions(Player player) {
        List<MobEffectInstance> effects = player.m_21220_().stream().filter(effectInstance -> effectInstance.m_19557_() < 160).filter(MobEffectInstance::m_19571_).filter(effect -> effect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL).toList();
        effects.forEach(e -> player.m_21195_(e.m_19544_()));
    }

    protected List<Player> getPlayers(Gaia gaia) {
        return gaia.m_6274_().m_21952_(MemoryModuleType.f_26367_).orElse(new ArrayList());
    }
}

