/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia.behavior;

import com.google.common.collect.ImmutableMap;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyMemoryType;
import io.github.lounode.extrabotany.common.entity.MagicLandMineEntity;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;

public class GaiaSpawnLandMine<E extends Gaia>
extends Behavior<E> {
    public static final int LANDMINE_COUNTS = 6;

    public GaiaSpawnLandMine() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26367_, (Object)MemoryStatus.VALUE_PRESENT, ExtraBotanyMemoryType.LANDMINE_COUNT, (Object)MemoryStatus.REGISTERED, ExtraBotanyMemoryType.TELEPORT_DELAY, (Object)MemoryStatus.REGISTERED));
    }

    public static void initMemories(Brain<? extends Gaia> brain, int mineCount) {
        brain.m_21879_(ExtraBotanyMemoryType.LANDMINE_COUNT, (Object)mineCount);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E gaia) {
        return this.getTeleportDelay((Gaia)((Object)gaia)) == 0;
    }

    protected void start(ServerLevel level, E gaia, long gameTime) {
        this.spawnLandMines((Gaia)((Object)gaia));
    }

    protected void spawnLandMines(Gaia gaia) {
        int count = this.getLandMineCount(gaia);
        BlockPos source = gaia.getHome().m_122646_();
        List<Player> players = this.getPlayers(gaia);
        if (players.isEmpty()) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            int x = source.m_123341_() - 10 + gaia.m_217043_().m_188503_(20);
            int y = (int)players.get(gaia.m_217043_().m_188503_(players.size())).m_20186_();
            int z = source.m_123343_() - 10 + gaia.m_217043_().m_188503_(20);
            MagicLandMineEntity landmine = (MagicLandMineEntity)ExtraBotanyEntityType.MAGIC_LANDMINE.m_20615_(gaia.m_9236_());
            landmine.m_6034_((double)x + 0.5, y, (double)z + 0.5);
            landmine.setOwner((Entity)gaia);
            gaia.m_9236_().m_7967_((Entity)landmine);
        }
    }

    protected int getTeleportDelay(Gaia gaia) {
        return gaia.m_6274_().m_21952_(ExtraBotanyMemoryType.TELEPORT_DELAY).orElse(35);
    }

    protected int getLandMineCount(Gaia gaia) {
        return gaia.m_6274_().m_21952_(ExtraBotanyMemoryType.LANDMINE_COUNT).orElse(6);
    }

    protected List<Player> getPlayers(Gaia gaia) {
        return gaia.m_6274_().m_21952_(MemoryModuleType.f_26367_).orElse(new ArrayList());
    }
}

