/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia.behavior;

import com.google.common.collect.ImmutableMap;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyMemoryType;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.item.BotaniaItems;

public class GaiaSpawnMob<E extends Gaia>
extends Behavior<E> {
    public GaiaSpawnMob(int duration) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26367_, (Object)MemoryStatus.VALUE_PRESENT, ExtraBotanyMemoryType.MOB_SPAWN_TICKS, (Object)MemoryStatus.VALUE_PRESENT), duration);
    }

    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        return true;
    }

    protected void start(ServerLevel level, E gaia, long gameTime) {
    }

    protected void tick(ServerLevel level, E gaia, long gameTime) {
        int countDown = this.getSpawnTicks((Gaia)((Object)gaia));
        int ticks = 900 - countDown;
        gaia.m_20256_(Vec3.f_82478_);
        ((Gaia)((Object)gaia)).setInvulTime(((Gaia)((Object)gaia)).getInvulTime() + 1);
        if (ticks < 20) {
            gaia.m_20334_(gaia.m_20184_().m_7096_(), 0.3, gaia.m_20184_().m_7094_());
        }
        if (ticks > 40 && countDown > 80 && countDown % 80 == 0) {
            this.spawnMobs((Gaia)((Object)gaia), this.getPlayers((Gaia)((Object)gaia)));
        }
        this.setSpawnTicks((Gaia)((Object)gaia), countDown - 1);
        if (countDown <= 0) {
            this.m_22562_(level, (LivingEntity)gaia, gameTime);
        }
    }

    private void spawnMobs(Gaia gaia, List<Player> players) {
        for (int pl = 0; pl < players.size(); ++pl) {
            for (int i = 0; i < 3 + gaia.m_9236_().f_46441_.m_188503_(2); ++i) {
                Witch entity;
                switch (gaia.m_9236_().f_46441_.m_188503_(3)) {
                    case 0: {
                        Witch witch;
                        if (gaia.m_9236_().f_46441_.m_188503_(12) == 0) {
                            witch = (Witch)EntityType.f_20495_.m_20615_(gaia.m_9236_());
                            break;
                        }
                        witch = (Zombie)EntityType.f_20501_.m_20615_(gaia.m_9236_());
                        break;
                    }
                    case 1: {
                        Witch witch;
                        if (gaia.m_9236_().f_46441_.m_188503_(8) == 0) {
                            witch = (WitherSkeleton)EntityType.f_20497_.m_20615_(gaia.m_9236_());
                            break;
                        }
                        witch = (Skeleton)EntityType.f_20524_.m_20615_(gaia.m_9236_());
                        break;
                    }
                    case 2: {
                        if (!players.isEmpty()) {
                            for (int j = 0; j < 1 + gaia.m_9236_().f_46441_.m_188503_(8); ++j) {
                                PixieEntity pixie = new PixieEntity(gaia.m_9236_());
                                pixie.setProps((LivingEntity)players.get(gaia.m_217043_().m_188503_(players.size())), (LivingEntity)gaia, 1, 8.0f);
                                pixie.m_6034_(gaia.m_20185_() + (double)(gaia.m_20205_() / 2.0f), gaia.m_20186_() + 2.0, gaia.m_20189_() + (double)(gaia.m_20205_() / 2.0f));
                                pixie.m_6518_((ServerLevelAccessor)gaia.m_9236_(), gaia.m_9236_().m_6436_(pixie.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                                gaia.m_9236_().m_7967_((Entity)pixie);
                            }
                        }
                        Witch witch = null;
                        break;
                    }
                    default: {
                        Witch witch = entity = null;
                    }
                }
                if (entity == null) continue;
                if (!entity.m_5825_()) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 600, 0));
                }
                float range = 6.0f;
                entity.m_6034_(gaia.m_20185_() + 0.5 + Math.random() * (double)range - (double)(range / 2.0f), gaia.m_20186_() - 1.0, gaia.m_20189_() + 0.5 + Math.random() * (double)range - (double)(range / 2.0f));
                entity.m_6518_((ServerLevelAccessor)gaia.m_9236_(), gaia.m_9236_().m_6436_(entity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                if (entity instanceof WitherSkeleton) {
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)BotaniaItems.elementiumSword));
                }
                gaia.m_9236_().m_7967_((Entity)entity);
            }
        }
    }

    protected void stop(ServerLevel level, E entity, long gameTime) {
        ((Gaia)((Object)entity)).m_6274_().m_21936_(ExtraBotanyMemoryType.MOB_SPAWN_TICKS);
    }

    protected List<Player> getPlayers(Gaia gaia) {
        return gaia.m_6274_().m_21952_(MemoryModuleType.f_26367_).orElse(new ArrayList());
    }

    protected int getSpawnTicks(Gaia gaia) {
        return gaia.m_6274_().m_21952_(ExtraBotanyMemoryType.MOB_SPAWN_TICKS).orElse(0);
    }

    protected void setSpawnTicks(Gaia gaia, int ticks) {
        gaia.m_6274_().m_21879_(ExtraBotanyMemoryType.MOB_SPAWN_TICKS, (Object)ticks);
    }
}

