/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia.behavior;

import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import io.github.lounode.extrabotany.common.entity.SkullLandMineEntity;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaSpawnLandMine;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class GaiaSpawnSkullLandMine<E extends Gaia>
extends GaiaSpawnLandMine<E> {
    public static final List<WeightedEntry.Wrapper<EntityType<? extends SkullLandMineEntity>>> TYPES_POOL = List.of(WeightedEntry.m_146290_(ExtraBotanyEntityType.SKULL_LANDMINE_BLUE, (int)70), WeightedEntry.m_146290_(ExtraBotanyEntityType.SKULL_LANDMINE_RED, (int)20), WeightedEntry.m_146290_(ExtraBotanyEntityType.SKULL_LANDMINE_GREEN, (int)10));

    @Override
    protected void spawnLandMines(Gaia gaia) {
        int count = this.getLandMineCount(gaia);
        BlockPos source = gaia.getHome().m_122646_();
        List<Player> players = this.getPlayers(gaia);
        if (players.isEmpty()) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            int x = source.m_123341_() - 10 + gaia.m_217043_().m_188503_(20);
            int y = (int)players.get(gaia.m_217043_().m_188503_(players.size())).m_20186_();
            int z = source.m_123343_() - 10 + gaia.m_217043_().m_188503_(20);
            SkullLandMineEntity landmine = this.getNewLandMine(gaia);
            landmine.m_6034_((double)x + 0.5, y, (double)z + 0.5);
            gaia.m_9236_().m_7967_((Entity)landmine);
        }
    }

    protected SkullLandMineEntity getNewLandMine(Gaia gaia) {
        EntityType landmineType = (EntityType)WeightedRandom.m_216822_((RandomSource)gaia.m_217043_(), TYPES_POOL).orElse(WeightedEntry.m_146290_(ExtraBotanyEntityType.SKULL_LANDMINE_BLUE, (int)70)).m_146310_();
        if (landmineType == ExtraBotanyEntityType.SKULL_LANDMINE_RED) {
            return new SkullLandMineEntity.Danger(gaia.m_9236_(), (Entity)gaia);
        }
        if (landmineType == ExtraBotanyEntityType.SKULL_LANDMINE_GREEN && !ExtraBotanyConfig.common().disableGaiaDisArm()) {
            return new SkullLandMineEntity.Disarm(gaia.m_9236_(), (Entity)gaia);
        }
        return new SkullLandMineEntity.Default(gaia.m_9236_(), (Entity)gaia);
    }
}

