/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia.behavior;

import com.google.common.collect.ImmutableMap;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyMemoryType;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.MathHelper;

public class GaiaTeleport<E extends Gaia>
extends Behavior<E> {
    public static final int TELEPORT_DELAY = 35;
    public static final float TELEPORT_RANGE = 12.0f;

    public GaiaTeleport() {
        super((Map)ImmutableMap.of(ExtraBotanyMemoryType.TELEPORT_DELAY_BASE, (Object)MemoryStatus.REGISTERED, ExtraBotanyMemoryType.TELEPORT_DELAY, (Object)MemoryStatus.REGISTERED, ExtraBotanyMemoryType.TELEPORT_RANGE, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26381_, (Object)MemoryStatus.REGISTERED));
    }

    public static void initMemories(Brain<? extends Gaia> brain, float range, int delay, int initDelay) {
        brain.m_21879_(ExtraBotanyMemoryType.TELEPORT_RANGE, (Object)Float.valueOf(range));
        brain.m_21879_(ExtraBotanyMemoryType.TELEPORT_DELAY_BASE, (Object)delay);
        brain.m_21879_(ExtraBotanyMemoryType.TELEPORT_DELAY, (Object)initDelay);
    }

    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        return true;
    }

    protected void start(ServerLevel level, E gaia, long gameTime) {
    }

    protected void tick(ServerLevel level, E gaia, long gameTime) {
        int delay = this.getTeleportDelay((Gaia)((Object)gaia));
        if (this.isHurt((Gaia)((Object)gaia))) {
            this.resolveHurt((Gaia)((Object)gaia));
        }
        if (delay > 0) {
            this.setTeleportDelay((Gaia)((Object)gaia), delay - 1);
            return;
        }
        this.randomTeleport((Gaia)((Object)gaia), this.getHome((Gaia)((Object)gaia)).m_122646_(), this.getTeleportRange((Gaia)((Object)gaia)));
    }

    protected void randomTeleport(Gaia gaia, BlockPos source, float range) {
        double newZ;
        double newX;
        double oldX = gaia.m_20185_();
        double oldY = gaia.m_20186_();
        double oldZ = gaia.m_20189_();
        double newY = source.m_123342_();
        int tries = 0;
        do {
            newX = (double)source.m_123341_() + (gaia.m_217043_().m_188500_() - 0.5) * (double)range;
            newZ = (double)source.m_123343_() + (gaia.m_217043_().m_188500_() - 0.5) * (double)range;
        } while (++tries < 50 && MathHelper.pointDistanceSpace((double)newX, (double)newY, (double)newZ, (double)source.m_123341_(), (double)source.m_123342_(), (double)source.m_123343_()) > range - 2.0f);
        if (tries == 50) {
            newX = (double)source.m_123341_() + 0.5;
            newY = (double)source.m_123342_() + 1.6;
            newZ = (double)source.m_123343_() + 0.5;
        }
        BlockPos tentativeFloorPos = BlockPos.m_274561_((double)newX, (double)(newY - 1.0), (double)newZ);
        if (gaia.m_9236_().m_8055_(tentativeFloorPos).m_60812_((BlockGetter)gaia.m_9236_(), tentativeFloorPos).m_83281_()) {
            newY -= 1.0;
        }
        gaia.m_6021_(newX, newY, newZ);
        this.setTeleportDelay(gaia, this.getTeleportDelayBase(gaia));
        gaia.m_9236_().m_6263_(null, oldX, oldY, oldZ, BotaniaSounds.gaiaTeleport, gaia.m_5720_(), 1.0f, 1.0f);
        gaia.m_5496_(BotaniaSounds.gaiaTeleport, 1.0f, 1.0f);
        this.particles(gaia, new Vec3(oldX, oldY, oldZ), new Vec3(newX, newY, newZ));
    }

    protected void particles(Gaia gaia, Vec3 oldPos, Vec3 newPos) {
        RandomSource random = RandomSource.m_216327_();
        int particleCount = 128;
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)(particleCount - 1);
            float vx = (random.m_188501_() - 0.5f) * 0.2f;
            float vy = (random.m_188501_() - 0.5f) * 0.2f;
            float vz = (random.m_188501_() - 0.5f) * 0.2f;
            double px = oldPos.m_7096_() + (newPos.m_7096_() - oldPos.m_7096_()) * progress + (random.m_188500_() - 0.5) * (double)gaia.m_20205_() * 2.0;
            double py = oldPos.m_7098_() + (newPos.m_7098_() - oldPos.m_7098_()) * progress + random.m_188500_() * (double)gaia.m_20206_();
            double pz = oldPos.m_7094_() + (newPos.m_7094_() - oldPos.m_7094_()) * progress + (random.m_188500_() - 0.5) * (double)gaia.m_20205_() * 2.0;
            gaia.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, px, py, pz, (double)vx, (double)vy, (double)vz);
        }
    }

    public GlobalPos getHome(Gaia gaia) {
        return gaia.getHome();
    }

    public void setTeleportDelay(Gaia gaia, int tpDelay) {
        gaia.m_6274_().m_21879_(ExtraBotanyMemoryType.TELEPORT_DELAY, (Object)tpDelay);
    }

    public int getTeleportDelay(Gaia gaia) {
        return gaia.m_6274_().m_21952_(ExtraBotanyMemoryType.TELEPORT_DELAY).orElse(35);
    }

    public float getTeleportRange(Gaia gaia) {
        return gaia.m_6274_().m_21952_(ExtraBotanyMemoryType.TELEPORT_RANGE).orElse(Float.valueOf(12.0f)).floatValue();
    }

    public int getTeleportDelayBase(Gaia gaia) {
        return gaia.m_6274_().m_21952_(ExtraBotanyMemoryType.TELEPORT_DELAY_BASE).orElse(35);
    }

    public boolean isHurt(Gaia gaia) {
        return gaia.m_6274_().m_21874_(MemoryModuleType.f_26381_);
    }

    protected void resolveHurt(Gaia gaia) {
        this.setTeleportDelay(gaia, 4);
        gaia.m_6274_().m_21936_(MemoryModuleType.f_26381_);
    }
}

