/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.integration.kubejs.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BlockStateIngredient;
import vazkii.botania.common.crafting.BlockStateStateIngredient;
import vazkii.botania.common.crafting.StateIngredientHelper;

public record BlockStateComponent(ComponentRole crole) implements RecipeComponent<StateIngredient>
{
    public static final RecipeComponent<StateIngredient> INPUT = new BlockStateComponent(ComponentRole.INPUT);
    public static final RecipeComponent<StateIngredient> OUTPUT = new BlockStateComponent(ComponentRole.OUTPUT);
    public static final RecipeComponent<StateIngredient> BLOCK = new BlockStateComponent(ComponentRole.OTHER);
    public static final StateIngredient EMPTY_INGREDIENT = new StateIngredient(){

        public boolean test(BlockState state) {
            return false;
        }

        public BlockState pick(RandomSource random) {
            return Blocks.f_50016_.m_49966_();
        }

        public JsonObject serialize() {
            return new JsonObject();
        }

        public void write(FriendlyByteBuf buffer) {
        }

        public List<ItemStack> getDisplayedStacks() {
            return List.of();
        }

        public List<BlockState> getDisplayed() {
            return List.of();
        }
    };

    public ComponentRole role() {
        return this.crole;
    }

    public String componentType() {
        return "block_state";
    }

    public Class<?> componentClass() {
        return StateIngredient.class;
    }

    public JsonElement write(RecipeJS recipe, StateIngredient value) {
        return value.serialize();
    }

    public StateIngredient read(RecipeJS recipe, Object from) {
        if (from instanceof StateIngredient) {
            StateIngredient in = (StateIngredient)from;
            return in;
        }
        if (from instanceof Block) {
            Block b = (Block)from;
            return StateIngredientHelper.of((Block)b);
        }
        if (from instanceof BlockState) {
            BlockState s = (BlockState)from;
            return StateIngredientHelper.of((BlockState)s);
        }
        if (from instanceof JsonObject) {
            JsonObject json = (JsonObject)from;
            return StateIngredientHelper.deserialize((JsonObject)json);
        }
        if (from instanceof CharSequence) {
            CharSequence chars = (CharSequence)from;
            String s = chars.toString();
            if (s.startsWith("#")) {
                ResourceLocation tagLocation = ResourceLocation.m_135820_((String)s.substring(1));
                return StateIngredientHelper.of((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tagLocation));
            }
            return StateIngredientHelper.of((BlockState)UtilsJS.parseBlockState((String)chars.toString()));
        }
        return EMPTY_INGREDIENT;
    }

    public boolean isInput(RecipeJS recipe, StateIngredient value, ReplacementMatch match) {
        return this.crole.isInput();
    }

    public boolean isOutput(RecipeJS recipe, StateIngredient value, ReplacementMatch match) {
        return this.crole.isOutput();
    }

    public String checkEmpty(RecipeKey<StateIngredient> key, StateIngredient value) {
        BlockStateStateIngredient ingr;
        BlockStateIngredient ingr2;
        if (value instanceof BlockStateIngredient && (ingr2 = (BlockStateIngredient)value).getBlock() == Blocks.f_50016_) {
            return "Blocks '" + key.name + "' can't be empty!";
        }
        if (value instanceof BlockStateStateIngredient && (ingr = (BlockStateStateIngredient)value).getState().m_60795_()) {
            return "Blocks '" + key.name + "' can't be empty!";
        }
        return "";
    }

    @Override
    public String toString() {
        return this.componentType();
    }
}

