/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.common.util.SoundEventUtil;
import java.util.UUID;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WalkingCaneItem
extends Item
implements Vanishable {
    private static final int MANA_PER_USE = 40;
    private static final double ADDITION_SPEED = 0.3;
    private static final int COOLDOWN_TICKS = 20;
    private static final float EXHAUSTION = 0.2f;

    public WalkingCaneItem(Item.Properties properties) {
        super(properties);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        Multimap ret = super.m_7167_(slot);
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            ret = HashMultimap.create((Multimap)ret);
            ret.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("995829fa-94c0-41bd-b046-0468c509a488"), "Cane modifier", this.getAdditionSpeed(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        return ret;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)entityLiving;
        int time = this.m_8105_(stack) - timeLeft;
        player.m_36324_().m_38703_(this.getExhaustion());
        player.m_6858_(true);
        player.m_246865_(this.getAdditionDeltaMovement(player, time));
        if (level.m_5776_()) {
            player.m_6330_(ExtraBotanySounds.WALKING_CANE_USE, SoundSource.PLAYERS, 1.0f, SoundEventUtil.randomPitch(level));
        }
        player.m_36335_().m_41524_((Item)this, this.getCooldownTicks());
    }

    public Vec3 getAdditionDeltaMovement(Player player, int time) {
        float speed;
        float yIncrease = 0.07f * (float)time + 0.67f;
        if (yIncrease > 0.7f) {
            yIncrease = 0.7f;
        }
        if ((speed = 0.12f * (float)time + 1.1f) > 1.825f) {
            speed = 1.825f;
        }
        float yaw = player.m_146908_() * ((float)Math.PI / 180);
        float xIncrease = -Mth.m_14031_((float)yaw) * speed;
        float zIncrease = Mth.m_14089_((float)yaw) * speed;
        return new Vec3((double)xIncrease, (double)yIncrease, (double)zIncrease);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public double getAdditionSpeed() {
        return 0.3;
    }

    public int getCooldownTicks() {
        return 20;
    }

    public float getExhaustion() {
        return 0.2f;
    }

    public int getManaPerUse() {
        return 40;
    }
}

