/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.armor.shadow_warrior;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.lounode.extrabotany.api.ExtraBotanyAPI;
import io.github.lounode.extrabotany.api.item.IShadowium;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.equipment.armor.starry_idol.StarryIdolArmorItem;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.handler.PixieHandler;

public class ShadowWarriorArmorItem
extends StarryIdolArmorItem
implements IShadowium {
    public static final Supplier<ItemStack[]> ARMOR_SET = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)ExtraBotanyItems.shadowWarriorHelmet), new ItemStack((ItemLike)ExtraBotanyItems.shadowWarriorChestplate), new ItemStack((ItemLike)ExtraBotanyItems.shadowWarriorLeggings), new ItemStack((ItemLike)ExtraBotanyItems.shadowWarriorBoots)});

    public ShadowWarriorArmorItem(ArmorItem.Type type, Item.Properties properties) {
        this(ExtraBotanyAPI.instance().getShadowWarriorArmorMaterial(), type, properties);
    }

    public ShadowWarriorArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        Multimap ret = super.m_7167_(slot);
        if (slot == this.m_266204_().m_266308_()) {
            UUID uuid = new UUID(BuiltInRegistries.f_257033_.m_7981_((Object)this).hashCode() + slot.toString().hashCode(), 0L);
            ret = HashMultimap.create((Multimap)ret);
            ret.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(uuid, "Combatmaid modifier" + String.valueOf(this.f_265916_), 5.0, AttributeModifier.Operation.ADDITION));
            ret.put((Object)PixieHandler.PIXIE_SPAWN_CHANCE, (Object)PixieHandler.makeModifier((EquipmentSlot)slot, (String)"Shadow Warrior modifier", (double)0.05));
        }
        return ret;
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            this.shadowiumTick(stack, world, entity, slot, selected);
        }
    }

    @Override
    public void shadowiumTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.m_6844_(this.f_265916_.m_266308_()) != stack) {
            return;
        }
        if (living.f_19797_ % 100 == 0) {
            return;
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            if (!ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getShadowiumBuffMana(), true)) {
                return;
            }
        }
        if (this.isNight(level) || this.isInCave(level, entity.m_20183_())) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 400));
        }
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return "extrabotany:textures/models/armor/shadow_warrior.png";
    }

    @Override
    public MutableComponent getArmorSetName() {
        return Component.m_237115_((String)"extrabotany.armorset.shadow_warrior.name");
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list, boolean hasArmorSet) {
        list.add((Component)Component.m_237115_((String)"extrabotany.armorset.shadow_warrior.desc0").m_130940_(hasArmorSet ? ChatFormatting.DARK_GRAY : ChatFormatting.GRAY));
    }

    @Override
    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null || player.m_150109_() == null || player.m_150109_().f_35975_ == null) {
            return false;
        }
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.m_150930_(ExtraBotanyItems.shadowWarriorHelmet);
            case EquipmentSlot.CHEST -> stack.m_150930_(ExtraBotanyItems.shadowWarriorChestplate);
            case EquipmentSlot.LEGS -> stack.m_150930_(ExtraBotanyItems.shadowWarriorLeggings);
            case EquipmentSlot.FEET -> stack.m_150930_(ExtraBotanyItems.shadowWarriorBoots);
            default -> false;
        };
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return ARMOR_SET.get();
    }
}

