/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.armor.starry_idol;

import com.google.common.base.Suppliers;
import io.github.lounode.extrabotany.api.ExtraBotanyAPI;
import io.github.lounode.extrabotany.api.client.IArmor;
import io.github.lounode.extrabotany.api.item.ArmorSet;
import io.github.lounode.extrabotany.api.item.ManaFixableItem;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.PhantomInkable;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class StarryIdolArmorItem
extends ArmorItem
implements CustomCreativeTabContents,
ManaFixableItem,
IArmor,
ArmorSet,
PhantomInkable {
    private static final String TAG_PHANTOM_INK = "phantomInk";
    private static final int MANA_PER_DAMAGE = 100;
    public static final Supplier<ItemStack[]> ARMOR_SET = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)ExtraBotanyItems.starryIdolHeadgear), new ItemStack((ItemLike)ExtraBotanyItems.starryIdolSuit), new ItemStack((ItemLike)ExtraBotanyItems.starryIdolSkirt), new ItemStack((ItemLike)ExtraBotanyItems.starryIdolBoots)});

    public StarryIdolArmorItem(ArmorItem.Type type, Item.Properties properties) {
        this(ExtraBotanyAPI.instance().getStarryIdolArmorMaterial(), type, properties);
    }

    public StarryIdolArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return ToolCommons.damageItemIfPossible((ItemStack)stack, (int)amount, entity, (int)this.getManaPerDamage());
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.triggerAdvancement(entity);
        this.tickManaFix(stack, world, entity, slot, selected);
    }

    @Override
    public final String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return this.hasPhantomInk(stack) ? "botania:textures/model/armor_invisible.png" : this.getArmorTextureAfterInk(stack, slot);
    }

    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return "extrabotany:textures/models/armor/starry_idol.png";
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flags) {
        TooltipHandler.addOnShift(list, () -> this.addInformation(stack, world, list, flags));
    }

    @Override
    public void addInformation(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        ArmorSet.super.addInformation(stack, world, list, flags);
        if (this.hasPhantomInk(stack)) {
            list.add((Component)Component.m_237115_((String)"botaniamisc.hasPhantomInk").m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null || player.m_150109_() == null || player.m_150109_().f_35975_ == null) {
            return false;
        }
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.m_150930_(ExtraBotanyItems.starryIdolHeadgear);
            case EquipmentSlot.CHEST -> stack.m_150930_(ExtraBotanyItems.starryIdolSuit);
            case EquipmentSlot.LEGS -> stack.m_150930_(ExtraBotanyItems.starryIdolSkirt);
            case EquipmentSlot.FEET -> stack.m_150930_(ExtraBotanyItems.starryIdolBoots);
            default -> false;
        };
    }

    @Override
    public MutableComponent getArmorSetName() {
        return Component.m_237115_((String)"extrabotany.armorset.starry_idol.name");
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list, boolean hasArmorSet) {
        list.add((Component)Component.m_237115_((String)"extrabotany.armorset.starry_idol.desc").m_130940_(hasArmorSet ? ChatFormatting.AQUA : ChatFormatting.GRAY));
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return ARMOR_SET.get();
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    public boolean hasPhantomInk(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_PHANTOM_INK, (boolean)false);
    }

    public void setPhantomInk(ItemStack stack, boolean ink) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_PHANTOM_INK, (boolean)ink);
    }

    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        output.m_246342_(new ItemStack((ItemLike)me));
    }
}

