/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.bauble;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

public class DispersiveRingItem
extends BaubleItem {
    private static final int RANGE = 7;
    private static final int DISPERSIVE_COOLDOWN = 20;

    public DispersiveRingItem(Item.Properties props) {
        super(props);
    }

    public void onWornTick(ItemStack stack, LivingEntity entity) {
        super.onWornTick(stack, entity);
        if (entity.m_9236_().m_5776_() || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.f_19797_ % this.getDispersiveCooldown() != 0) {
            return;
        }
        BlockPos.m_121921_((AABB)new AABB(player.m_20183_()).m_82400_(7.0)).forEach(pos -> {
            BlockEntity tile = player.m_9236_().m_7702_(pos);
            if (tile instanceof FunctionalFlowerBlockEntity) {
                FunctionalFlowerBlockEntity flower = (FunctionalFlowerBlockEntity)tile;
                int mana = flower.getMaxMana() - flower.getMana();
                if (ManaItemHandler.instance().requestManaExact(stack, player, mana, true)) {
                    flower.addMana(mana);
                }
            }
        });
    }

    public int getDispersiveCooldown() {
        return 20;
    }

    public int getRange() {
        return 7;
    }
}

