/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.bauble;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

public class FrostRingItem
extends BaubleItem {
    private static final int RANGE = 6;

    public FrostRingItem(Item.Properties props) {
        super(props);
    }

    public void onWornTick(ItemStack stack, LivingEntity entity) {
        super.onWornTick(stack, entity);
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        FrostWalkerEnchantment.m_45018_((LivingEntity)entity, (Level)entity.m_9236_(), (BlockPos)entity.m_20183_(), (int)this.getRange());
        FrostRingItem.freezeLava(entity, entity.m_9236_(), entity.m_20183_(), this.getRange());
        this.slowDownMobsNearby(entity);
    }

    public void slowDownMobsNearby(LivingEntity owner) {
        List entities = owner.m_9236_().m_45976_(LivingEntity.class, new AABB(owner.m_20182_(), owner.m_20182_()).m_82400_((double)this.getRange()));
        for (LivingEntity living : entities) {
            if (living == owner || !FrostRingItem.isLookingAt(owner, living)) continue;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 4));
        }
    }

    private static boolean isLookingAt(LivingEntity from, LivingEntity toCheck) {
        Vec3 vec3 = from.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(toCheck.m_20185_() - from.m_20185_(), toCheck.m_20188_() - from.m_20188_(), toCheck.m_20189_() - from.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && from.m_142582_((Entity)toCheck);
    }

    public static void freezeLava(LivingEntity living, Level level, BlockPos pos, int levelConflicting) {
        if (living.m_20096_()) {
            BlockState blockstate = Blocks.f_50080_.m_49966_();
            int i = Math.min(16, 2 + levelConflicting);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-i, -1, -i), (BlockPos)pos.m_7918_(i, -1, i))) {
                BlockState blockstate2;
                if (!blockpos.m_203195_((Position)living.m_20182_(), (double)i)) continue;
                blockpos$mutableblockpos.m_122178_(blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_());
                BlockState blockstate1 = level.m_8055_((BlockPos)blockpos$mutableblockpos);
                if (!blockstate1.m_60795_() || (blockstate2 = level.m_8055_(blockpos)) != Blocks.f_49991_.m_49966_() || !blockstate.m_60710_((LevelReader)level, blockpos) || !level.m_45752_(blockstate, blockpos, CollisionContext.m_82749_())) continue;
                level.m_46597_(blockpos, blockstate);
                level.m_186460_(blockpos, Blocks.f_50080_, Mth.m_216271_((RandomSource)living.m_217043_(), (int)60, (int)120));
            }
        }
    }

    public int getRange() {
        return 6;
    }
}

