/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.tool.hammer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.equipment.tool.hammer.ManasteelHammerItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.lib.BotaniaTags;

public class ElementiumHammerItem
extends ManasteelHammerItem {
    private static final int MANA_PER_DAMAGE = 70;

    public ElementiumHammerItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public static boolean shouldFilterOut(Entity e, ItemStack tool, ItemStack drop) {
        if (tool.m_41619_() || !tool.m_150930_(ExtraBotanyItems.elementiumHammer)) {
            return false;
        }
        if (e.m_6144_()) {
            return false;
        }
        return ElementiumHammerItem.isDisposable(drop) || ElementiumHammerItem.isSemiDisposable(drop);
    }

    private static boolean isDisposable(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_204117_(BotaniaTags.Items.DISPOSABLE);
    }

    private static boolean isSemiDisposable(ItemStack stack) {
        return stack.m_204117_(BotaniaTags.Items.SEMI_DISPOSABLE);
    }

    @Override
    public int getManaPerDamage() {
        return 70;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot slot) {
        Multimap ret = super.m_7167_(slot);
        if (slot == EquipmentSlot.MAINHAND) {
            ret = HashMultimap.create((Multimap)ret);
            ret.put((Object)PixieHandler.PIXIE_SPAWN_CHANCE, (Object)PixieHandler.makeModifier((EquipmentSlot)slot, (String)"Sword modifier", (double)0.05));
        }
        return ret;
    }
}

