/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.tool.hammer;

import io.github.lounode.eventwrapper.event.entity.player.PlayerEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.api.item.IAerialite;
import io.github.lounode.extrabotany.api.item.IOrichalcos;
import io.github.lounode.extrabotany.api.item.IPhotonium;
import io.github.lounode.extrabotany.api.item.IShadowium;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.equipment.tool.hammer.TerrasteelHammerItem;
import io.github.lounode.extrabotany.common.item.material.HammerTiers;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.Relic;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

@EventBusSubscriberWrapper
public class RheinHammerItem
extends TerrasteelHammerItem
implements IShadowium,
IPhotonium,
IAerialite,
IOrichalcos {
    private static final int MANA_PER_DAMAGE = 300;
    private static final int ACTIVE_COST = 30;
    public static final int RANGE = 5;
    public static final int BUFF_MANA = 200;
    private static final String ADVANCEMENT_NAME = "spongebob";

    public RheinHammerItem(Item.Properties props) {
        this(HammerTiers.RHEIN, 4, -3.0f, props);
    }

    public RheinHammerItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        RelicImpl.addDefaultTooltip((ItemStack)stack, tooltipComponents);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        ServerPlayer serverPlayer;
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
        }
        if (entity instanceof ServerPlayer && this.checkAdvancement(stack, serverPlayer = (ServerPlayer)entity)) {
            PlayerHelper.grantCriterion((ServerPlayer)serverPlayer, (ResourceLocation)ResourceLocationHelper.prefix("main/sponge_hammer"), (String)"code_triggered");
        }
        if (!RheinHammerItem.isEnabled(stack)) {
            return;
        }
        this.shadowiumTick(stack, world, entity, slot, selected);
        this.photoniumTick(stack, world, entity, slot, selected);
        this.aerialiteTick(stack, world, entity, slot, selected);
        this.orichalcosTick(stack, world, entity, slot, selected);
    }

    private boolean checkAdvancement(ItemStack stack, ServerPlayer serverPlayer) {
        if (PlayerHelper.hasAdvancement((ServerPlayer)serverPlayer, (ResourceLocation)ResourceLocationHelper.prefix("main/sponge_hammer"))) {
            return false;
        }
        return ADVANCEMENT_NAME.equals(stack.m_41786_().getString().toLowerCase(Locale.ROOT));
    }

    public boolean m_41386_(DamageSource damageSource) {
        return IOrichalcos.canBeHurtBy(damageSource);
    }

    @SubscribeEventWrapper
    public static void onDig(PlayerEventWrapper.BreakSpeed wrapper) {
        ItemStack _left = wrapper.getEntity().m_21120_(InteractionHand.OFF_HAND);
        ItemStack _right = wrapper.getEntity().m_21120_(InteractionHand.MAIN_HAND);
        ItemStack stack = ItemStack.f_41583_;
        if (_left.m_150930_(ExtraBotanyItems.rheinHammer)) {
            stack = _left;
        } else if (_right.m_150930_(ExtraBotanyItems.rheinHammer)) {
            stack = _right;
        }
        if (stack.m_41619_() || !stack.m_150930_(ExtraBotanyItems.rheinHammer)) {
            return;
        }
        if (stack.m_150930_(ExtraBotanyItems.rheinHammer) && !RheinHammerItem.isEnabled(stack)) {
            wrapper.setNewSpeed(0.0f);
            wrapper.setCanceled(true);
        }
    }

    @Override
    public int getManaPerDamage() {
        return 300;
    }

    @Override
    public int getActiveCost() {
        return 30;
    }

    @Override
    public int getRange(Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        return 5;
    }

    @Override
    public int getShadowiumBuffMana() {
        return 200;
    }

    @Override
    public int getPhotoniumBuffMana() {
        return 200;
    }

    @Override
    public int getAerialiteBuffMana() {
        return 200;
    }

    @Override
    public int getOrichalcosBuffMana() {
        return 200;
    }

    @Override
    public boolean isNight(Level level) {
        return true;
    }

    @Override
    public boolean isInCave(Level level, BlockPos pos) {
        return true;
    }

    @Override
    public boolean isDay(Level level) {
        return true;
    }

    @Override
    public boolean isOutCave(Level level, BlockPos pos) {
        return true;
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("main/rhein_kraft"));
    }
}

