/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.material;

import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.common.item.BotaniaItems;

public enum ArmorsMaterial implements ArmorMaterial,
StringRepresentable
{
    STARRY_IDOL("starry_idol", 16, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 2);
        map.put(ArmorItem.Type.LEGGINGS, 5);
        map.put(ArmorItem.Type.CHESTPLATE, 6);
        map.put(ArmorItem.Type.HELMET, 2);
    }), 18, ExtraBotanySounds.ARMOR_EQUIP_IDOL, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.manaweaveCloth})),
    PLEIADS_MAID_COMBAT("pleiads_maid_combat", 50, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 4);
        map.put(ArmorItem.Type.LEGGINGS, 7);
        map.put(ArmorItem.Type.CHESTPLATE, 8);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 50, ExtraBotanySounds.ARMOR_EQUIP_MAID, 4.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{ExtraBotanyItems.dasRheingold})),
    GOBLIN_SLAYER("goblin_slayer", 21, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 6);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 40, ExtraBotanySounds.ARMOR_EQUIP_GOBLIN, 2.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{ExtraBotanyItems.photonium})),
    SHADOW_WARRIOR("shadow_warrior", 23, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 7);
        map.put(ArmorItem.Type.CHESTPLATE, 6);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 28, ExtraBotanySounds.ARMOR_EQUIP_WARRIOR, 1.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{ExtraBotanyItems.shadowium}));

    public static final StringRepresentable.EnumCodec<ArmorsMaterial> CODEC;
    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    private ArmorsMaterial(String name, int durabilityMultiplier, EnumMap<ArmorItem.Type, Integer> protectionFunctionForType, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionFunctionForType = protectionFunctionForType;
        this.enchantmentValue = enchantmentValue;
        this.sound = sound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = new LazyLoadedValue(repairIngredient);
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionFunctionForType.get(type);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public String m_7912_() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.m_216439_(ArmorsMaterial::values);
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 13);
            map.put(ArmorItem.Type.LEGGINGS, 15);
            map.put(ArmorItem.Type.CHESTPLATE, 16);
            map.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

