/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.lounode.eventwrapper.event.entity.player.AttackEntityEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.PlayerInteractEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.common.ExtraBotanyDamageTypes;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.material.ItemTiers;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.network.serverbound.LeftClickPacketExcalibur;
import io.github.lounode.extrabotany.xplat.ExClientXplatAbstractions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelSwordItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

@EventBusSubscriberWrapper
public class ExcaliburItem
extends ManasteelSwordItem
implements LensEffectItem {
    private static final int MANA_PER_DAMAGE = 200;
    public static final double SEARCH_TARGET_RADIUS = 5.0;

    public ExcaliburItem(Item.Properties props) {
        super((Tier)ItemTiers.EXCALIBUR, 8, -2.0f, props);
    }

    @SubscribeEventWrapper
    public static void leftClick(PlayerInteractEventWrapper.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && stack.m_41720_() instanceof ExcaliburItem) {
            ExClientXplatAbstractions.INSTANCE.sendToServer(LeftClickPacketExcalibur.INSTANCE);
        }
    }

    @SubscribeEventWrapper
    public static void attackEntity(AttackEntityEventWrapper event) {
        Player player = event.getEntity();
        if (!player.m_9236_().f_46443_ && player.m_21205_().m_41720_() instanceof ExcaliburItem) {
            ExcaliburItem.trySpawnBurst(player, player.m_36403_(0.0f));
        }
    }

    public static void trySpawnBurst(Player player, float attackStrength) {
        ItemStack stack = player.m_21205_();
        if (!stack.m_150930_(ExtraBotanyItems.excalibur)) {
            return;
        }
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic == null || !relic.isRightPlayer(player)) {
            return;
        }
        ExcaliburItem.trySpawnBurstUnsafe(player, attackStrength);
    }

    public static void trySpawnBurstUnsafe(Player player, float attackStrength) {
        if (player.m_5833_() || attackStrength != 1.0f) {
            return;
        }
        ManaBurstEntity burst = ExcaliburItem.getBurst(player, player.m_21205_());
        player.m_9236_().m_7967_((Entity)burst);
        player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ExtraBotanySounds.EXCALIBUR_ATTACK, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        Multimap ret = super.m_7167_(slot);
        if (slot == EquipmentSlot.MAINHAND) {
            ret = HashMultimap.create((Multimap)ret);
            ret.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("995829fa-94c0-41bd-b046-0468c509a488"), "Excaliber modifier", 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        return ret;
    }

    public static ManaBurstEntity getBurst(Player player, ItemStack stack) {
        ManaBurstEntity burst = new ManaBurstEntity(player){

            public boolean m_142391_() {
                return false;
            }
        };
        float motionModifier = 9.0f;
        burst.setColor(0xFFFF20);
        burst.setMana(200);
        burst.setStartingMana(200);
        burst.setMinManaLoss(40);
        burst.setManaLossPerTick(4.0f);
        burst.setGravity(0.0f);
        burst.m_20256_(burst.m_20184_().m_82490_((double)motionModifier));
        burst.setSourceLens(stack.m_41777_());
        return burst;
    }

    public void updateBurst(ManaBurst burst, ItemStack stack) {
        block8: {
            Player player;
            Entity thrower;
            ManaBurstEntity burstEntity;
            block7: {
                block6: {
                    burstEntity = (ManaBurstEntity)burst.entity();
                    thrower = burstEntity.m_19749_();
                    if (!(thrower instanceof Player)) break block6;
                    player = (Player)thrower;
                    if (thrower.m_6084_()) break block7;
                }
                burstEntity.m_146870_();
                return;
            }
            this.rotateToEnemy(burstEntity);
            if (burstEntity.m_9236_().m_5776_()) {
                return;
            }
            AABB axis = new AABB(burstEntity.m_20185_(), burstEntity.m_20186_(), burstEntity.m_20189_(), burstEntity.f_19790_, burstEntity.f_19791_, burstEntity.f_19792_).m_82400_(1.0);
            List<LivingEntity> entities = burstEntity.m_9236_().m_45976_(LivingEntity.class, axis).stream().filter(e -> e != thrower).filter(e -> {
                Player other;
                return !(e instanceof Player && !player.m_7099_(other = (Player)e));
            }).filter(e -> e.f_20916_ == 0).toList();
            Iterator<LivingEntity> iterator = entities.iterator();
            if (!iterator.hasNext()) break block8;
            LivingEntity entity = iterator.next();
            int cost = 66;
            int mana = burst.getMana();
            if (mana >= cost) {
                burst.setMana(mana - cost);
                float damage = 5.0f + ItemTiers.EXCALIBUR.m_6631_();
                DamageSource source = ExtraBotanyDamageTypes.Sources.excaliburDamage(player.m_9236_().m_9598_(), (Entity)player);
                entity.m_6469_(source, damage);
                burstEntity.m_146870_();
            }
        }
    }

    private void rotateToEnemy(ManaBurstEntity burstEntity) {
        AABB searchBox = new AABB(burstEntity.m_20185_(), burstEntity.m_20186_(), burstEntity.m_20189_(), burstEntity.f_19790_, burstEntity.f_19791_, burstEntity.f_19792_).m_82400_(5.0);
        burstEntity.m_9236_().m_45976_(LivingEntity.class, searchBox).stream().filter(ExcaliburItem::canTargetEntity).filter(living -> living.f_20916_ == 0).filter(living -> living != burstEntity.m_19749_()).sorted(Comparator.comparingInt(ExcaliburItem::getEntityPriority)).findFirst().ifPresent(target -> {
            Vec3 thisVec = VecHelper.fromEntityCenter((Entity)burstEntity);
            Vec3 targetVec = VecHelper.fromEntityCenter((Entity)target);
            Vec3 diffVec = targetVec.m_82546_(thisVec);
            Vec3 motionVec = diffVec.m_82541_().m_82490_(0.6);
            burstEntity.m_20256_(motionVec);
        });
    }

    private static boolean canTargetEntity(LivingEntity entity) {
        return entity instanceof Mob || entity instanceof Player;
    }

    private static int getEntityPriority(LivingEntity entity) {
        if (entity instanceof Mob) {
            return 3;
        }
        if (entity instanceof Player) {
            return 2;
        }
        if (entity instanceof Animal) {
            return 1;
        }
        return 0;
    }

    public void apply(ItemStack stack, BurstProperties props, Level level) {
    }

    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        return shouldKill;
    }

    public boolean doParticles(ManaBurst burst, ItemStack stack) {
        return true;
    }

    public int getManaPerDamage() {
        return 200;
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, null);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return super.m_6832_(toRepair, repair);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.extrabotany.excalibur").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        tooltip.add((Component)Component.m_237113_((String)""));
        RelicImpl.addDefaultTooltip((ItemStack)stack, tooltip);
    }

    public static boolean isSaber(ItemStack stack) {
        String name = stack.m_41786_().getString().toLowerCase(Locale.ROOT).trim();
        return "saber".equals(name);
    }
}

